/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.date;

import cn.buli_home.utils.date.WeekDay;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DateUtils {
    private static final Map<String, SimpleDateFormat> simpleDateFormatMap = new HashMap<String, SimpleDateFormat>();

    private static SimpleDateFormat p_getSimpleDateFormat(String formatStyle) {
        SimpleDateFormat dateFormat = simpleDateFormatMap.get(formatStyle);
        if (Objects.nonNull(dateFormat)) {
            return dateFormat;
        }
        return new SimpleDateFormat(formatStyle);
    }

    public static String format(Date date, String formatStyle) {
        if (Objects.isNull(date)) {
            return "";
        }
        return DateUtils.p_getSimpleDateFormat(formatStyle).format(date);
    }

    public static String formatDate(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd");
    }

    public static String formatDateTimeSecond(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDateTimeMillisecond(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd HH:mm:ss:SSS");
    }

    public static Date parseDate(String dateString) {
        return DateUtils.parse(dateString, "yyyy-MM-dd");
    }

    public static Date parseDateTimeSecond(String dateTimeStr) {
        return DateUtils.parse(dateTimeStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseDateTimeMillisecond(String dateTimeStr) {
        return DateUtils.parse(dateTimeStr, "yyyy-MM-dd HH:mm:ss:SSS");
    }

    public static Date parse(String dateString, String formatStyle) {
        String s = DateUtils.p_getString(dateString);
        if (s.isEmpty()) {
            return null;
        }
        try {
            return DateUtils.p_getSimpleDateFormat(formatStyle).parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String p_getString(String s) {
        return Objects.isNull(s) ? "" : s.trim();
    }

    public static Date getDateStart(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDateEnd(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static int getDateNo(Date date) {
        if (Objects.isNull(date)) {
            return 0;
        }
        return Integer.parseInt(DateUtils.format(date, "yyyyMMdd"));
    }

    public static long getDateTimeSecond(Date date) {
        if (Objects.isNull(date)) {
            return 0L;
        }
        return Long.parseLong(DateUtils.format(date, "yyyyMMddHHmmss"));
    }

    public static long getDateTimeMillisecond(Date date) {
        if (Objects.isNull(date)) {
            return 0L;
        }
        return Long.parseLong(DateUtils.format(date, "yyyyMMddHHmmssSSS"));
    }

    public static long getTimestampSecond(Date date) {
        return date.getTime() / 1000L;
    }

    public static long getTimestampMillisecond(Date date) {
        return date.getTime();
    }

    private static int p_getWeek(Date date) {
        if (Objects.isNull(date)) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.p_getWeek(calendar);
    }

    private static int p_getWeek(Calendar calendar) {
        switch (calendar.get(7)) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 1: {
                return 7;
            }
        }
        return 0;
    }

    public static int getWeekOfYear(Date date) {
        if (Objects.isNull(date)) {
            return -1;
        }
        int weeks = DateUtils.getWeekOfYearIgnoreLastYear(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        int week = DateUtils.p_getWeek(calendar);
        if (week == 1) {
            return weeks;
        }
        return weeks - 1;
    }

    public static int getWeekOfYearIgnoreLastYear(Date date) {
        if (Objects.isNull(date)) {
            return -1;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int days = calendar.get(6);
        int weeks = days / 7;
        if (days % 7 == 0) {
            return weeks;
        }
        return weeks + 1;
    }

    public static DateNode getDateNode(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateNode node = new DateNode();
        node.setTime(DateUtils.format(date, "yyyy-MM-dd HH:mm:ss:SSS"));
        node.setYear(calendar.get(1));
        node.setMonth(calendar.get(2) + 1);
        node.setDay(calendar.get(5));
        node.setHour(calendar.get(11));
        node.setMinute(calendar.get(12));
        node.setSecond(calendar.get(13));
        node.setMillisecond(calendar.get(14));
        node.setWeek(DateUtils.p_getWeek(calendar));
        node.setDayOfYear(calendar.get(6));
        node.setWeekOfYear(DateUtils.getWeekOfYear(date));
        node.setWeekOfYearIgnoreLastYear(DateUtils.getWeekOfYearIgnoreLastYear(date));
        node.setMillisecondStamp(date.getTime());
        node.setSecondStamp(date.getTime() / 1000L);
        return node;
    }

    public static Date add(Date date, int field, int amount) {
        if (Objects.isNull(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static Date addYear(Date date, int year) {
        return DateUtils.add(date, 1, year);
    }

    public static Date addMonth(Date date, int month) {
        return DateUtils.add(date, 2, month);
    }

    public static Date addDay(Date date, int day) {
        return DateUtils.add(date, 6, day);
    }

    public static Date addWeek(Date date, int week) {
        return DateUtils.add(date, 3, week);
    }

    public static Date addHour(Date date, int hour) {
        return DateUtils.add(date, 11, hour);
    }

    public static Date addMinute(Date date, int minute) {
        return DateUtils.add(date, 12, minute);
    }

    public static Date addSecond(Date date, int second) {
        return DateUtils.add(date, 13, second);
    }

    public static Date addMillisecond(Date date, int millisecond) {
        return DateUtils.add(date, 14, millisecond);
    }

    public static Date getWeekDate(Date date, WeekDay weekDay) {
        int week = DateUtils.p_getWeek(date);
        return DateUtils.addDay(date, weekDay.getDay() - week);
    }

    public static Date getWeekDateStart(Date date) {
        return DateUtils.getDateStart(DateUtils.getWeekDate(date, WeekDay.Monday));
    }

    public static Date getWeekDateEnd(Date date) {
        return DateUtils.getWeekDateEnd(DateUtils.getWeekDate(date, WeekDay.Sunday));
    }

    public static List<Date> getWeekDateList(Date date) {
        if (Objects.isNull(date)) {
            return Collections.emptyList();
        }
        Date weekFromDate = DateUtils.getWeekDateStart(date);
        Date weekeEndDate = DateUtils.getWeekDateEnd(date);
        return DateUtils.getBetweenDateList(weekFromDate, weekeEndDate, true);
    }

    public static List<String> getWeekDateList(String dateString) {
        Date date = DateUtils.parseDate(dateString);
        if (Objects.isNull(date)) {
            return Collections.emptyList();
        }
        return DateUtils.getDateStrList(DateUtils.getWeekDateList(date));
    }

    public static List<Date> getMonthDateList(Date date) {
        if (Objects.isNull(date)) {
            return Collections.emptyList();
        }
        Date monthDateStart = DateUtils.getMonthDateStart(date);
        Date monthDateEnd = DateUtils.getMonthDateEnd(date);
        return DateUtils.getBetweenDateList(monthDateStart, monthDateEnd, true);
    }

    public static List<String> getMonthDateList(String dateString) {
        Date date = DateUtils.parseDate(dateString);
        if (Objects.isNull(date)) {
            return Collections.emptyList();
        }
        return DateUtils.getDateStrList(DateUtils.getMonthDateList(date));
    }

    public static Date getMonthDateStart(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return DateUtils.getDateStart(calendar.getTime());
    }

    public static Date getMonthDateEnd(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        Date monthDateStart = DateUtils.getMonthDateStart(date);
        Date nextMonthDateStart = DateUtils.getMonthDateStart(DateUtils.addMonth(monthDateStart, 1));
        return DateUtils.getDateEnd(DateUtils.addDay(nextMonthDateStart, -1));
    }

    public static Integer compareDays(Date date1, Date date2) {
        if (Objects.isNull(date1) || Objects.isNull(date2)) {
            return null;
        }
        long ts1 = DateUtils.getTimestampMillisecond(date1);
        long ts2 = DateUtils.getTimestampMillisecond(date2);
        if (ts2 - ts1 == 0L) {
            return 0;
        }
        if (ts1 > ts2) {
            return 1;
        }
        return -1;
    }

    public static int countBetweenDays(Date date1, Date date2) {
        if (Objects.isNull(date1) || Objects.isNull(date2)) {
            return -1;
        }
        long t1 = DateUtils.getDateStart(date1).getTime();
        long t2 = DateUtils.getDateStart(date2).getTime();
        return (int)(Math.abs(t1 - t2) / 86400000L);
    }

    public static List<Date> getBetweenDateList(Date date1, Date date2) {
        return DateUtils.getBetweenDateList(date1, date2, false);
    }

    public static List<Date> getBetweenDateList(Date date1, Date date2, boolean isContainParams) {
        if (Objects.isNull(date1) || Objects.isNull(date2)) {
            return Collections.emptyList();
        }
        Date fromDate = date1;
        Date toDate = date2;
        if (date2.before(date1)) {
            fromDate = date2;
            toDate = date1;
        }
        Date from = DateUtils.getDateStart(fromDate);
        Date to = DateUtils.getDateStart(toDate);
        ArrayList<Date> dates = new ArrayList<Date>();
        if (isContainParams) {
            dates.add(from);
        }
        Date date = from;
        boolean isBefore = true;
        while (isBefore) {
            isBefore = (date = DateUtils.addDay(date, 1)).before(to);
            if (!isBefore) continue;
            dates.add(DateUtils.getDateStart(date));
        }
        if (isContainParams) {
            dates.add(to);
        }
        return dates;
    }

    public static List<String> getBetweenDateList(String dateString1, String dateString2) {
        return DateUtils.getBetweenDateList(dateString1, dateString2, false);
    }

    public static List<String> getBetweenDateList(String dateString1, String dateString2, boolean isContainParams) {
        Date date1 = DateUtils.parseDate(dateString1);
        Date date2 = DateUtils.parseDate(dateString2);
        List<Date> dates = DateUtils.getBetweenDateList(date1, date2, isContainParams);
        return DateUtils.getDateStrList(dates);
    }

    public static List<String> getDateStrList(List<Date> dates) {
        if (dates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> dateList = new ArrayList<String>();
        for (Date date : dates) {
            dateList.add(DateUtils.formatDate(date));
        }
        return dateList;
    }

    public static String convertMillisecond2TimeStr(long millisecond) {
        if (millisecond < 1000L) {
            return millisecond + "ms";
        }
        long sec = millisecond / 1000L;
        long mil = millisecond % 1000L;
        return DateUtils.convertSecond2TimeStr(sec) + mil + "ms";
    }

    public static String convertSecond2TimeStr(long second) {
        if (second < 60L) {
            return second + "s";
        }
        long min = second / 60L;
        long sec = second % 60L;
        return DateUtils.convertMinute2TimeStr(min) + sec + "s";
    }

    public static String convertMinute2TimeStr(long minute) {
        if (minute < 60L) {
            return minute + "m";
        }
        if (minute < 1440L) {
            long hour = minute / 60L;
            long min = minute % 60L;
            return hour + "h" + min + "m";
        }
        long day = minute / 1440L;
        long hour = minute % 1440L / 60L;
        long min = minute % 60L;
        return day + "d" + hour + "h" + min + "m";
    }

    static {
        simpleDateFormatMap.put("yyyy-MM-dd", new SimpleDateFormat("yyyy-MM-dd"));
        simpleDateFormatMap.put("yyyy-MM-dd HH", new SimpleDateFormat("yyyy-MM-dd HH"));
        simpleDateFormatMap.put("yyyy-MM-dd HH:mm", new SimpleDateFormat("yyyy-MM-dd HH:mm"));
        simpleDateFormatMap.put("yyyy-MM-dd HH:mm:ss", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        simpleDateFormatMap.put("yyyy-MM-dd HH:mm:ss:SSS", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS"));
        simpleDateFormatMap.put("yyyyMMdd", new SimpleDateFormat("yyyyMMdd"));
        simpleDateFormatMap.put("yyyyMMddHH", new SimpleDateFormat("yyyyMMddHH"));
        simpleDateFormatMap.put("yyyyMMddHHmm", new SimpleDateFormat("yyyyMMddHHmm"));
        simpleDateFormatMap.put("yyyyMMddHHmmss", new SimpleDateFormat("yyyyMMddHHmmss"));
        simpleDateFormatMap.put("yyyyMMddHHmmssSSS", new SimpleDateFormat("yyyyMMddHHmmssSSS"));
    }

    static class DateNode {
        private int year;
        private int month;
        private int day;
        private int hour;
        private int minute;
        private int second;
        private int millisecond;
        private int week;
        private int dayOfYear;
        private int weekOfYear;
        private int weekOfYearIgnoreLastYear;
        private long secondStamp;
        private long millisecondStamp;
        private String time;

        DateNode() {
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int day) {
            this.day = day;
        }

        public int getHour() {
            return this.hour;
        }

        public void setHour(int hour) {
            this.hour = hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public void setMinute(int minute) {
            this.minute = minute;
        }

        public int getSecond() {
            return this.second;
        }

        public void setSecond(int second) {
            this.second = second;
        }

        public int getMillisecond() {
            return this.millisecond;
        }

        public void setMillisecond(int millisecond) {
            this.millisecond = millisecond;
        }

        public int getWeek() {
            return this.week;
        }

        public void setWeek(int week) {
            this.week = week;
        }

        public int getDayOfYear() {
            return this.dayOfYear;
        }

        public void setDayOfYear(int dayOfYear) {
            this.dayOfYear = dayOfYear;
        }

        public int getWeekOfYear() {
            return this.weekOfYear;
        }

        public void setWeekOfYear(int weekOfYear) {
            this.weekOfYear = weekOfYear;
        }

        public int getWeekOfYearIgnoreLastYear() {
            return this.weekOfYearIgnoreLastYear;
        }

        public void setWeekOfYearIgnoreLastYear(int weekOfYearIgnoreLastYear) {
            this.weekOfYearIgnoreLastYear = weekOfYearIgnoreLastYear;
        }

        public long getSecondStamp() {
            return this.secondStamp;
        }

        public void setSecondStamp(long secondStamp) {
            this.secondStamp = secondStamp;
        }

        public long getMillisecondStamp() {
            return this.millisecondStamp;
        }

        public void setMillisecondStamp(long millisecondStamp) {
            this.millisecondStamp = millisecondStamp;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }
    }
}

