/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.kafka;

import cn.buli_home.utils.kafka.AsyncSendCallback;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaUtils {
    private static final AsyncSendCallback callback = new AsyncSendCallback();

    public static KafkaProducer<String, String> getStringProducer(String servers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", servers);
        properties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return new KafkaProducer(properties);
    }

    public static void sendAsyncMessage(KafkaProducer<String, String> producer, String topic, String value) {
        KafkaUtils.sendAsyncMessage(producer, topic, value, true);
    }

    public static void sendAsyncMessage(KafkaProducer<String, String> producer, String topic, String value, boolean isLog) {
        ProducerRecord record = new ProducerRecord(topic, (Object)value);
        KafkaUtils.callback.isLog = isLog;
        producer.send(record, (Callback)callback);
    }

    public static Set<String> getTopics(String servers) throws ExecutionException, InterruptedException {
        AdminClient adminClient = KafkaUtils.p_getAdminClient(servers);
        ListTopicsResult result = adminClient.listTopics();
        adminClient.close();
        Set set = (Set)result.names().get();
        return set;
    }

    public static void createTopic(String servers, String topic, int numPartitions, int replicationFactor) {
        AdminClient adminClient = KafkaUtils.p_getAdminClient(servers);
        NewTopic newTopic = new NewTopic(topic, numPartitions, (short)replicationFactor);
        adminClient.createTopics(Collections.singletonList(newTopic));
        adminClient.close();
    }

    public static AdminClient p_getAdminClient(String servers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", servers);
        return KafkaAdminClient.create((Properties)properties);
    }
}

