/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.file.CommonFileUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static List<Tuple2<Integer, String>> readFileByLine(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String temp = null;
        int line = 1;
        ArrayList<Tuple2<Integer, String>> resultList = new ArrayList<Tuple2<Integer, String>>();
        while ((temp = reader.readLine()) != null) {
            resultList.add((Tuple2<Integer, String>)Tuple.of((Object)line, (Object)temp));
            ++line;
        }
        if (reader != null) {
            reader.close();
        }
        return resultList;
    }

    public static void writeFile(String path, String content, boolean overwrite) throws Exception {
        Path oPath = Paths.get(path, new String[0]);
        boolean exists = Files.exists(oPath, new LinkOption[0]);
        if (exists) {
            if (!overwrite) {
                return;
            }
            Files.delete(oPath);
        }
        RandomAccessFile stream = new RandomAccessFile(path, "rw");
        FileChannel channel = stream.getChannel();
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        channel.write(buffer);
        channel.close();
        stream.close();
    }

    public static String readFile(String path) {
        boolean exists = CommonFileUtils.existsFile(path);
        if (!exists) {
            return "";
        }
        File file = new File(path);
        InputStreamReader reader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int tempchar;
            reader = new InputStreamReader(new FileInputStream(file));
            while ((tempchar = ((Reader)reader).read()) != -1) {
                if ((char)tempchar == '\r') continue;
                stringBuilder.append((char)tempchar);
            }
            ((Reader)reader).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }
}

