/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.common;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class StringUtils {
    public static boolean isEmpty(String str) {
        return Objects.isNull(str) || str.length() == 0;
    }

    public static boolean isEmptyWithoutBlank(String str) {
        return StringUtils.isEmpty(StringUtils.replaceBlank(str));
    }

    public static String replaceBlank(String str) {
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        Pattern p = Pattern.compile("\\s*|\t|\r|\n|&nbsp;");
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    public static String convert2String(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            if (((String)obj).equalsIgnoreCase("NULL") || ((String)obj).equalsIgnoreCase("<null>")) {
                return "";
            }
            return (String)obj;
        }
        return obj.toString();
    }

    public static String upperFirst(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!Character.isLetter(c)) continue;
            chars[i] = StringUtils.p_upperChar(c);
            break;
        }
        return String.valueOf(chars);
    }

    public static String lowerFirst(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!Character.isLetter(c)) continue;
            chars[i] = StringUtils.p_lowerChar(c);
            break;
        }
        return String.valueOf(chars);
    }

    public static String camel2Underline(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                char ch_ucase = StringUtils.p_lowerChar(ch);
                if (i > 0) {
                    buf.append('_');
                }
                buf.append(ch_ucase);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String underline2Camel(String str) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        String[] split = str.split("_");
        StringBuilder sb = new StringBuilder(str.length());
        for (String s : split) {
            sb.append(StringUtils.lowerFirst(s));
        }
        return sb.toString();
    }

    public static String removePrefix(String str, String[] prefix) {
        if (Objects.isNull(str) || str.length() == 0) {
            return "";
        }
        if (null != prefix) {
            String[] prefixArray = prefix;
            for (int i = 0; i < prefix.length; ++i) {
                String pf = prefixArray[i];
                if (!str.toLowerCase().matches("^" + pf.toLowerCase() + ".*")) continue;
                return str.substring(pf.length());
            }
        }
        return str;
    }

    public static Integer parseInt(String str) {
        String tmpStr = StringUtils.convert2String(str);
        if (tmpStr.equals("")) {
            return 0;
        }
        int n = 0;
        try {
            n = (int)Double.parseDouble(tmpStr);
        }
        catch (Exception e) {
            return 0;
        }
        return n;
    }

    public static Long parseLong(String str) {
        String tmpStr = StringUtils.convert2String(str);
        if (tmpStr.equals("")) {
            return 0L;
        }
        long n = 0L;
        try {
            n = Long.parseLong(tmpStr);
        }
        catch (Exception e) {
            return 0L;
        }
        return n;
    }

    public static Double parseDouble(String str) {
        String tmpStr = StringUtils.convert2String(str);
        if (tmpStr.equals("")) {
            return 0.0;
        }
        Double n = 0.0;
        try {
            n = Double.parseDouble(tmpStr);
        }
        catch (Exception e) {
            return 0.0;
        }
        return n;
    }

    public static Boolean parseBoolean(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes");
    }

    public static String getSplitAtIdx(String str, String regex, int idx) {
        String string = StringUtils.convert2String(str);
        String[] array = string.split(regex);
        if (array.length > idx) {
            return array[idx];
        }
        return "";
    }

    public static boolean hasSpecialChar(String str) {
        String regEx = "[ _`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\n|\r|\t";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static int bytesLength(String str) {
        return StringUtils.convert2String(str).getBytes().length;
    }

    public static String base64(String str) {
        return Base64.encodeBase64String((byte[])StringUtils.convert2String(str).getBytes(StandardCharsets.UTF_8));
    }

    public static String md5(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return Hex.encodeHexString((byte[])md5.digest(StringUtils.convert2String(str).getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static char p_upperChar(char c) {
        if (c >= 'a') {
            c = (char)(c - 32);
        }
        return c;
    }

    private static char p_lowerChar(char c) {
        if (c < 'a') {
            c = (char)(c + 32);
        }
        return c;
    }
}

