/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.file.CommonFileUtils;
import cn.buli_home.utils.file.FileWriteType;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    private static final int BUFFER_SIZE = 1024;
    private static final String NEWLINE_CONTENT = "\r\n";
    private static final String FILE_OPEN_MODE = "rw";

    public static List<Tuple2<Integer, String>> readFileByLine(File file) throws Exception {
        ArrayList<Tuple2<Integer, String>> resultList = new ArrayList<Tuple2<Integer, String>>();
        ByteBuffer rebuff = ByteBuffer.allocate(1024);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        int lineIdx = 0;
        byte CF = "\n".getBytes()[0];
        byte[] temp = new byte[]{};
        while (fileChannel.read(rebuff) != -1) {
            byte[] rbyte = new byte[rebuff.position()];
            rebuff.flip();
            rebuff.get(rbyte);
            int startNum = 0;
            for (int i = 0; i < rbyte.length; ++i) {
                if (rbyte[i] != CF) continue;
                byte[] line = new byte[temp.length + i - startNum];
                System.arraycopy(temp, 0, line, 0, temp.length);
                System.arraycopy(rbyte, startNum, line, temp.length, i - startNum);
                startNum = i + 1;
                temp = new byte[]{};
                String lineStr = new String(line, StandardCharsets.UTF_8);
                resultList.add((Tuple2<Integer, String>)Tuple.of((Object)lineIdx, (Object)lineStr));
                ++lineIdx;
            }
            if (startNum < rbyte.length) {
                byte[] temp2 = new byte[temp.length + rbyte.length - startNum];
                System.arraycopy(temp, 0, temp2, 0, temp.length);
                System.arraycopy(rbyte, startNum, temp2, temp.length, rbyte.length - startNum);
                temp = temp2;
            }
            rebuff.clear();
        }
        if (temp.length > 0) {
            String lineStr = new String(temp, StandardCharsets.UTF_8);
            resultList.add((Tuple2<Integer, String>)Tuple.of((Object)lineIdx, (Object)lineStr));
        }
        fileChannel.close();
        return resultList;
    }

    @Deprecated
    public static void writeFile(String path, String content, boolean overwrite) throws Exception {
        FileUtils.writeFile(path, content, overwrite ? FileWriteType.OVERWRITE : FileWriteType.ONCE);
    }

    public static void writeFile(String path, String content, FileWriteType writeType) throws Exception {
        Path oPath = Paths.get(path, new String[0]);
        if (writeType == FileWriteType.ONCE && Files.exists(oPath, new LinkOption[0])) {
            return;
        }
        if (writeType == FileWriteType.OVERWRITE) {
            Files.delete(oPath);
        }
        RandomAccessFile raFile = new RandomAccessFile(path, FILE_OPEN_MODE);
        FileChannel channel = raFile.getChannel();
        String writeContent = content;
        if (writeType == FileWriteType.APPEND_NEWLINE && channel.size() != 0L) {
            writeContent = NEWLINE_CONTENT.concat(content);
        }
        byte[] bytes = writeContent.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        channel.position(channel.size());
        buffer.clear();
        buffer.put(bytes);
        buffer.flip();
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
        channel.close();
        raFile.close();
    }

    @Deprecated
    public static void writeFile(File file, String content, boolean overwrite) throws Exception {
        FileUtils.writeFile(file, content, overwrite ? FileWriteType.OVERWRITE : FileWriteType.ONCE);
    }

    public static void writeFile(File file, String content, FileWriteType writeType) throws Exception {
        FileUtils.writeFile(file.getPath(), content, writeType);
    }

    public static String readFile(String path) throws Exception {
        boolean exists = CommonFileUtils.existsFile(path);
        if (!exists) {
            throw new FileNotFoundException();
        }
        RandomAccessFile raFile = new RandomAccessFile(path, FILE_OPEN_MODE);
        FileChannel channel = raFile.getChannel();
        ByteBuffer buf = ByteBuffer.allocate(1024);
        StringBuilder stringBuilder = new StringBuilder();
        int bytesRead = channel.read(buf);
        while (bytesRead != -1) {
            buf.flip();
            while (buf.hasRemaining()) {
                char tChar = (char)buf.get();
                if (tChar == '\r') continue;
                stringBuilder.append(tChar);
            }
            buf.clear();
            bytesRead = channel.read(buf);
        }
        channel.close();
        raFile.close();
        return stringBuilder.toString();
    }

    public static void createFolder(String path) throws IOException {
        if (FileUtils.folderExists(path)) {
            return;
        }
        Path iPath = Paths.get(path, new String[0]);
        Files.createDirectories(iPath, new FileAttribute[0]);
    }

    public static boolean folderExists(String path) {
        File file = new File(path);
        return file.exists() && file.isDirectory();
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean renameFile(String oldPath, String newPath) {
        File file = new File(oldPath);
        if (!file.exists()) {
            return false;
        }
        return file.renameTo(new File(newPath));
    }
}

