/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.excel;

import cn.buli_home.utils.excel.ExcelDataCallback;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.fastjson2.JSON;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExcelDataListener<T>
implements ReadListener<T> {
    private static final Logger log = LogManager.getLogger(ExcelDataListener.class);
    private static final int BATCH_COUNT = 100;
    private List<T> cachedDataList = ListUtils.newArrayListWithExpectedSize((int)100);
    private ExcelDataCallback<T> callback;

    public ExcelDataListener() {
    }

    public ExcelDataListener(ExcelDataCallback<T> callback) {
        this.callback = callback;
    }

    public void invoke(T data, AnalysisContext context) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString(data));
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 100) {
            if (Objects.nonNull(this.callback)) {
                this.callback.invoke(this.cachedDataList);
            }
            this.cachedDataList = ListUtils.newArrayListWithExpectedSize((int)100);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (Objects.nonNull(this.callback)) {
            this.callback.invoke(this.cachedDataList);
            this.callback.finish();
        }
        this.cachedDataList = ListUtils.newArrayListWithExpectedSize((int)100);
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }
}

