/*
 * Decompiled with CFR 0.152.
 */
package cn.buli_home.utils.file;

import cn.buli_home.utils.file.CommonFileUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Tuple2<Integer, String>> readFileByLine(File file) throws Exception {
        BufferedReader reader = null;
        String temp = null;
        int line = 1;
        ArrayList<Tuple2<Integer, String>> resultList = new ArrayList<Tuple2<Integer, String>>();
        try {
            reader = new BufferedReader(new FileReader(file));
            while ((temp = reader.readLine()) != null) {
                resultList.add((Tuple2<Integer, String>)Tuple.of((Object)line, (Object)temp));
                ++line;
            }
        }
        finally {
            if (Objects.nonNull(reader)) {
                reader.close();
            }
        }
        return resultList;
    }

    public static void writeFile(String path, String content, boolean overwrite) throws Exception {
        Path oPath = Paths.get(path, new String[0]);
        boolean exists = Files.exists(oPath, new LinkOption[0]);
        if (exists) {
            if (!overwrite) {
                return;
            }
            Files.delete(oPath);
        }
        RandomAccessFile stream = new RandomAccessFile(path, "rw");
        FileChannel channel = stream.getChannel();
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        channel.write(buffer);
        channel.close();
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String content, boolean overwrite) throws Exception {
        if (Objects.isNull(file)) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(file, !overwrite);
            writer.append(content);
            writer.flush();
        }
        finally {
            if (Objects.nonNull(writer)) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String path) throws Exception {
        boolean exists = CommonFileUtils.existsFile(path);
        if (!exists) {
            return "";
        }
        File file = new File(path);
        Reader reader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int tempchar;
            reader = new InputStreamReader(new FileInputStream(file));
            while ((tempchar = reader.read()) != -1) {
                if ((char)tempchar == '\r') continue;
                stringBuilder.append((char)tempchar);
            }
        }
        finally {
            if (Objects.nonNull(reader)) {
                reader.close();
            }
        }
        return stringBuilder.toString();
    }

    public static void createFolder(String path) throws IOException {
        if (FileUtils.folderExists(path)) {
            return;
        }
        Path iPath = Paths.get(path, new String[0]);
        Files.createDirectories(iPath, new FileAttribute[0]);
    }

    public static boolean folderExists(String path) {
        File file = new File(path);
        return file.exists() && file.isDirectory();
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean renameFile(String oldPath, String newPath) {
        File file = new File(oldPath);
        if (!file.exists()) {
            return false;
        }
        return file.renameTo(new File(newPath));
    }
}

