/*
 * Decompiled with CFR 0.152.
 */
package cn.brainpoint.febs.identify;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObjectId {
    public static final int OBJECT_ID_LENGTH = 12;
    public static final int OBJECT_ID_LENGTH_NOPID = 10;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final AtomicInteger NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static long preTimestamp = 0L;
    private final int timestamp;
    private final int counter;
    private final int randomValue1;
    private final short randomValue2;
    private final boolean noRandomValue2;

    public static String generateHex(int machineId, short pid) {
        ObjectId id = new ObjectId(new Date(), machineId, pid);
        return id.toHexString();
    }

    public static String generateHexNoPID(int machineId) {
        ObjectId id = new ObjectId(new Date(), machineId);
        return id.toHexString();
    }

    private ObjectId(Date date, int machineId) {
        if (preTimestamp > date.getTime()) {
            throw new IllegalArgumentException("The 'date' must bigger then pre-time.");
        }
        preTimestamp = date.getTime();
        if ((machineId & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The machine identifier must be between 0 and 16777214 (it must fit in three bytes).");
        }
        if (machineId == 0) {
            throw new IllegalArgumentException("Need a machine id.");
        }
        int inc = NEXT_COUNTER.getAndIncrement();
        if (inc > 0xFFFFFF) {
            NEXT_COUNTER.set(0);
            inc = NEXT_COUNTER.getAndIncrement();
        }
        this.timestamp = (int)(date.getTime() / 1000L);
        this.counter = inc & 0xFFFFFF;
        this.randomValue1 = machineId;
        this.randomValue2 = 0;
        this.noRandomValue2 = true;
    }

    private ObjectId(Date date, int machineId, short pid) {
        if (preTimestamp > date.getTime()) {
            throw new IllegalArgumentException("The 'date' must bigger then pre-time.");
        }
        preTimestamp = date.getTime();
        if ((machineId & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The machine identifier must be between 0 and 16777214 (it must fit in three bytes).");
        }
        int inc = NEXT_COUNTER.getAndIncrement();
        if (inc > 0xFFFFFF) {
            NEXT_COUNTER.set(0);
            inc = NEXT_COUNTER.getAndIncrement();
        }
        this.timestamp = (int)(date.getTime() / 1000L);
        this.counter = inc & 0xFFFFFF;
        this.randomValue1 = machineId;
        this.randomValue2 = pid;
        this.noRandomValue2 = false;
    }

    public byte[] toByteArray() {
        ByteBuffer buffer = null;
        buffer = this.noRandomValue2 ? ByteBuffer.allocate(10) : ByteBuffer.allocate(12);
        this.putToByteBuffer(buffer);
        return buffer.array();
    }

    public void putToByteBuffer(ByteBuffer buffer) {
        if (null == buffer) {
            throw new IllegalArgumentException("buffer is empty");
        }
        if (!(!this.noRandomValue2 && buffer.remaining() >= 12 || this.noRandomValue2 && buffer.remaining() >= 10)) {
            throw new IllegalArgumentException("buffer.remaining() >=12");
        }
        buffer.put(ObjectId.int3(this.timestamp));
        buffer.put(ObjectId.int2(this.timestamp));
        buffer.put(ObjectId.int1(this.timestamp));
        buffer.put(ObjectId.int0(this.timestamp));
        buffer.put(ObjectId.int2(this.randomValue1));
        buffer.put(ObjectId.int1(this.randomValue1));
        buffer.put(ObjectId.int0(this.randomValue1));
        if (!this.noRandomValue2) {
            buffer.put(ObjectId.short1(this.randomValue2));
            buffer.put(ObjectId.short0(this.randomValue2));
        }
        buffer.put(ObjectId.int2(this.counter));
        buffer.put(ObjectId.int1(this.counter));
        buffer.put(ObjectId.int0(this.counter));
    }

    public String toHexString() {
        char[] chars = null;
        chars = this.noRandomValue2 ? new char[20] : new char[24];
        int i = 0;
        for (byte b : this.toByteArray()) {
            chars[i++] = HEX_CHARS[b >> 4 & 0xF];
            chars[i++] = HEX_CHARS[b & 0xF];
        }
        return new String(chars);
    }

    public String toString() {
        return this.toHexString();
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }
}

