/*
 * Decompiled with CFR 0.152.
 */
package cn.brainpoint.febs.identify;

public class IdentifyCfg {
    protected String type;
    protected String url;
    protected String username;
    protected String password;
    protected String tablename;
    protected int retryCount;
    protected int connectTimeout;

    protected IdentifyCfg() {
    }

    public IdentifyCfg(String type, String url, String username, String password) {
        this.type = type;
        this.url = url;
        this.username = username;
        this.password = password;
        this.tablename = null;
        this.retryCount = 0;
        this.connectTimeout = 0;
    }

    public IdentifyCfg(String type, String url, String username, String password, String tablename, int retryCount, int connectTimeout) {
        this.type = type;
        this.url = url;
        this.username = username;
        this.password = password;
        this.tablename = tablename;
        this.retryCount = retryCount;
        this.connectTimeout = connectTimeout;
    }

    public String getDriver() {
        if (this.type.equals("mysql")) {
            return "com.mysql.cj.jdbc.Driver";
        }
        throw new RuntimeException("only support mysql");
    }

    public String getUri() {
        if (this.type.equals("mysql")) {
            return "jdbc:mysql://" + this.url + "?autoReconnect=true&autoReconnectForPools=true";
        }
        throw new RuntimeException("only support mysql");
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTablename() {
        return this.tablename;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentifyCfg)) {
            return false;
        }
        IdentifyCfg other = (IdentifyCfg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tablename = this.getTablename();
        String other$tablename = other.getTablename();
        if (this$tablename == null ? other$tablename != null : !this$tablename.equals(other$tablename)) {
            return false;
        }
        if (this.getRetryCount() != other.getRetryCount()) {
            return false;
        }
        return this.getConnectTimeout() == other.getConnectTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdentifyCfg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tablename = this.getTablename();
        result = result * 59 + ($tablename == null ? 43 : $tablename.hashCode());
        result = result * 59 + this.getRetryCount();
        result = result * 59 + this.getConnectTimeout();
        return result;
    }

    public String toString() {
        return "IdentifyCfg(type=" + this.getType() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tablename=" + this.getTablename() + ", retryCount=" + this.getRetryCount() + ", connectTimeout=" + this.getConnectTimeout() + ")";
    }
}

