/*
 * Decompiled with CFR 0.152.
 */
package cn.brainpoint.febs.identify;

import cn.brainpoint.febs.identify.IdentifyCfg;
import cn.brainpoint.febs.identify.ObjectId;
import cn.brainpoint.febs.identify.dao.BaseService;
import cn.brainpoint.febs.identify.dao.MachineIdService;
import cn.brainpoint.febs.identify.exception.DBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identify {
    private static final Logger log = LoggerFactory.getLogger(Identify.class);
    private static int machineId = 0;
    private static final int ID_LENGTH = 20;
    private static final String DEFAULT_TABLENAME = "_distribute_machineId";

    public static void initializeByMachineId(int machine_id) {
        log.info(String.format("[febs] Machine ID: %s;", machine_id %= 0xFFFFFF));
        machineId = machine_id;
    }

    public static void initializeByDatabase(IdentifyCfg config) {
        if (config != null) {
            Identify.setupDatabase(config);
        }
        try {
            machineId = Identify.generateNewMachineId();
        }
        catch (DBException e) {
            log.error(e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
        log.info(String.format("[febs] Machine ID: %s; Url: %s; Table: %s", machineId, Configuration.url, Configuration.tablename));
    }

    public static void setupDatabase(IdentifyCfg config) {
        int connectTimeout;
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        if (config.getDriver() == null || config.getUri() == null || config.getPassword() == null || config.getUsername() == null) {
            throw new IllegalArgumentException("cfg is error");
        }
        String tablename = config.getTablename();
        if (null != tablename) {
            tablename = tablename.trim();
        }
        String dbTablename = tablename == null || tablename.length() == 0 ? DEFAULT_TABLENAME : tablename;
        int n = connectTimeout = config.getConnectTimeout() <= 0 ? 5000 : config.getConnectTimeout();
        if (dbTablename.equals(Configuration.tablename) && config.getDriver().equals(Configuration.driver) && config.getUri().equals(Configuration.url) && config.getUsername().equals(Configuration.username) && config.getPassword().equals(Configuration.password)) {
            return;
        }
        Configuration.driver = config.getDriver();
        Configuration.url = config.getUri();
        Configuration.username = config.getUsername();
        Configuration.password = config.getPassword();
        Configuration.tablename = dbTablename;
        Configuration.retryCount = config.getRetryCount();
        BaseService.initialize(Configuration.driver, Configuration.url, Configuration.username, Configuration.password, connectTimeout);
    }

    public static int getMachineId() {
        return machineId;
    }

    public static int generateNewMachineId() throws DBException {
        int machine_id = 0;
        int i = 0;
        int retryCount = Configuration.retryCount;
        while (true) {
            try {
                MachineIdService service = new MachineIdService();
                machine_id = service.getNewMachineId().intValue();
            }
            catch (Exception e) {
                if (retryCount <= 0) {
                    throw new DBException("Get Machine id error", e);
                }
                log.warn("Get Machine id error", (Throwable)e);
                log.info(String.format("[febs-identify] retry connect %d", ++i));
                if (--retryCount >= 0) continue;
            }
            break;
        }
        return machine_id %= 0xFFFFFF;
    }

    public static String nextId() {
        String id = ObjectId.generateHexNoPID(machineId);
        assert (id.length() == 20) : "generate objectID length != OBJECT_ID_LENGTH_noPID*2";
        return id;
    }

    public static boolean isValid(String ... ids) {
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            if (null == id || id.length() != 20) {
                return false;
            }
            for (int j = 0; j < id.length(); ++j) {
                char c = id.charAt(j);
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
                return false;
            }
        }
        return true;
    }

    public static class Configuration {
        private static String driver;
        private static String url;
        private static String username;
        private static String password;
        private static String tablename;
        private static int retryCount;

        public static String getTablename() {
            return tablename;
        }
    }
}

