/*
 * Decompiled with CFR 0.152.
 */
package cn.brainpoint.febs.identify.starter.event;

import cn.brainpoint.febs.identify.starter.IdentifyProperties;
import cn.brainpoint.febs.identify.starter.IdentifyService;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class RefreshRemoteListener
implements ApplicationListener<RefreshRemoteApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(RefreshRemoteListener.class);
    @Autowired
    private Environment env;
    @Autowired
    private ContextRefresher contextRefresher;

    public void onApplicationEvent(RefreshRemoteApplicationEvent event) {
        Set keys = this.contextRefresher.refresh();
        if (keys.isEmpty()) {
            return;
        }
        this.handleRefreshIdentify(keys, null);
    }

    public void handleRefreshIdentify(Set<String> keys, ApplicationContext context) {
        if (!RefreshRemoteListener.containerKey(keys, "febs.identify.createMachineIdSelf", "febs.identify.db.type", "febs.identify.db.url", "febs.identify.db.username", "febs.identify.db.password", "febs.identify.db.tablename", "febs.identify.db.retryCount", "febs.identify.db.connectTimeout")) {
            return;
        }
        boolean createMachineIdSelf = (Boolean)this.env.getProperty("febs.identify.createMachineIdSelf", Boolean.class, (Object)false);
        String type = (String)this.env.getProperty("febs.identify.db.type", String.class);
        String url = (String)this.env.getProperty("febs.identify.db.url", String.class);
        String username = (String)this.env.getProperty("febs.identify.db.username", String.class);
        String password = (String)this.env.getProperty("febs.identify.db.password", String.class);
        String tablename = (String)this.env.getProperty("febs.identify.db.tablename", String.class);
        Integer retryCount = (Integer)this.env.getProperty("febs.identify.db.retryCount", Integer.class);
        Integer connectTimeout = (Integer)this.env.getProperty("febs.identify.db.connectTimeout", Integer.class);
        new IdentifyService(createMachineIdSelf, IdentifyProperties.DB.Make(type, url, username, password, tablename, retryCount == null ? 0 : retryCount, connectTimeout == null ? 0 : connectTimeout));
    }

    private static boolean containerKey(Set<String> keys, String ... key) {
        if (null == keys) {
            return true;
        }
        for (String k : key) {
            if (!keys.contains(k)) continue;
            return true;
        }
        return false;
    }
}

