/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.starter.data.perm.sensitive;

import cn.bootx.platform.starter.data.perm.sensitive.SensitiveInfo;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class SensitiveInfoSerialize
extends JsonSerializer<String>
implements ContextualSerializer {
    private SensitiveInfo sensitiveInfo;

    public void serialize(String s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        switch (this.sensitiveInfo.value()) {
            case CHINESE_NAME: {
                jsonGenerator.writeString(DesensitizedUtil.chineseName((String)s));
                break;
            }
            case USER_ID: {
                jsonGenerator.writeString(String.valueOf(DesensitizedUtil.userId()));
                break;
            }
            case PASSWORD: {
                jsonGenerator.writeString(DesensitizedUtil.password((String)s));
                break;
            }
            case ID_CARD: {
                jsonGenerator.writeString(DesensitizedUtil.idCardNum((String)s, (int)6, (int)2));
                break;
            }
            case FIXED_PHONE: {
                jsonGenerator.writeString(DesensitizedUtil.fixedPhone((String)s));
                break;
            }
            case MOBILE_PHONE: {
                jsonGenerator.writeString(DesensitizedUtil.mobilePhone((String)s));
                break;
            }
            case IP: {
                jsonGenerator.writeString(this.ip(s));
                break;
            }
            case ADDRESS: {
                jsonGenerator.writeString(DesensitizedUtil.address((String)s, (int)6));
                break;
            }
            case CAR_LICENSE: {
                jsonGenerator.writeString(DesensitizedUtil.carLicense((String)s));
                break;
            }
            case EMAIL: {
                jsonGenerator.writeString(DesensitizedUtil.email((String)s));
                break;
            }
            case BANK_CARD: {
                jsonGenerator.writeString(DesensitizedUtil.bankCard((String)s));
                break;
            }
            case CNAPS_CODE: {
                jsonGenerator.writeString(this.hide(s, 4, 4));
                break;
            }
            case OTHER: {
                jsonGenerator.writeString(this.hide(s, this.sensitiveInfo.front(), this.sensitiveInfo.end()));
                break;
            }
            default: {
                jsonGenerator.writeString(s);
            }
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            if (Objects.equals(beanProperty.getType().getRawClass(), String.class)) {
                SensitiveInfo sensitiveInfo = (SensitiveInfo)beanProperty.getAnnotation(SensitiveInfo.class);
                if (sensitiveInfo == null) {
                    sensitiveInfo = (SensitiveInfo)beanProperty.getContextAnnotation(SensitiveInfo.class);
                }
                if (sensitiveInfo != null) {
                    return new SensitiveInfoSerialize(sensitiveInfo);
                }
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(null);
    }

    private String ip(String ip) {
        List ipList = StrUtil.split((CharSequence)ip, (char)'.');
        if (ipList.size() < 2) {
            return "*.*.*.*";
        }
        return (String)ipList.get(0) + "." + (String)ipList.get(1) + ".*.*";
    }

    private String hide(String str, int front, int end) {
        if (StrUtil.isBlank((CharSequence)str)) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return StrUtil.hide((CharSequence)str, (int)front, (int)(str.length() - end));
    }

    public SensitiveInfoSerialize(SensitiveInfo sensitiveInfo) {
        this.sensitiveInfo = sensitiveInfo;
    }

    public SensitiveInfoSerialize() {
    }
}

