/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.starter.data.perm.select;

import cn.bootx.platform.common.core.annotation.NestedPermission;
import cn.bootx.platform.common.core.annotation.Permission;
import cn.bootx.platform.common.core.entity.UserDetail;
import cn.bootx.platform.common.core.util.CollUtil;
import cn.bootx.platform.starter.data.perm.configuration.DataPermProperties;
import cn.bootx.platform.starter.data.perm.exception.NotLoginPermException;
import cn.bootx.platform.starter.data.perm.local.DataPermContextHolder;
import cn.bootx.platform.starter.data.perm.select.SelectFieldPermHandler;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SelectFieldPermInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SelectFieldPermInterceptor.class);
    private final DataPermProperties dataPermProperties;
    private final SelectFieldPermHandler selectFieldPermHandler;

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (!this.checkPermission()) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            if (CollUtil.isNotEmpty((Collection)plainSelect.getJoins())) {
                return;
            }
            String tableName = plainSelect.getFromItem().toString();
            List selectItems = plainSelect.getSelectItems();
            List<SelectItem> newSelectItems = this.selectFieldPermHandler.filterFields(selectItems, tableName);
            plainSelect.setSelectItems(newSelectItems);
        }
    }

    protected boolean checkPermission() {
        if (!this.dataPermProperties.isEnableSelectFieldPerm()) {
            return false;
        }
        NestedPermission nestedPermission = DataPermContextHolder.getNestedPermission();
        if (Objects.nonNull(nestedPermission) && !nestedPermission.selectField()) {
            return false;
        }
        Permission permission = DataPermContextHolder.getPermission();
        if (Objects.isNull(permission) || !permission.selectField()) {
            return false;
        }
        return DataPermContextHolder.getUserDetail().map(UserDetail::isAdmin).orElseThrow(NotLoginPermException::new) == false;
    }

    public SelectFieldPermInterceptor(DataPermProperties dataPermProperties, SelectFieldPermHandler selectFieldPermHandler) {
        this.dataPermProperties = dataPermProperties;
        this.selectFieldPermHandler = selectFieldPermHandler;
    }
}

