/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.starter.data.perm.scope;

import cn.bootx.platform.common.core.annotation.NestedPermission;
import cn.bootx.platform.common.core.annotation.Permission;
import cn.bootx.platform.common.core.entity.UserDetail;
import cn.bootx.platform.common.core.exception.BizException;
import cn.bootx.platform.common.core.util.CollUtil;
import cn.bootx.platform.common.mybatisplus.util.MpUtil;
import cn.bootx.platform.starter.data.perm.code.DataScopeEnum;
import cn.bootx.platform.starter.data.perm.configuration.DataPermProperties;
import cn.bootx.platform.starter.data.perm.exception.NotLoginPermException;
import cn.bootx.platform.starter.data.perm.local.DataPermContextHolder;
import cn.bootx.platform.starter.data.perm.scope.DataPermScope;
import cn.bootx.platform.starter.data.perm.scope.DataPermScopeHandler;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataScopeInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataScopeInterceptor.class);
    private final DataPermProperties dataPermProperties;
    private final DataPermScopeHandler dataPermScopeHandler;

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (!this.checkPermission()) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) {
        if (!this.checkPermission()) {
            return;
        }
        if (ms.getSqlCommandType() == SqlCommandType.INSERT) {
            return;
        }
        BoundSql boundSql = ms.getBoundSql(parameter);
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            this.setWhere((PlainSelect)selectBody);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            selectBodyList.forEach(s -> this.setWhere((PlainSelect)s));
        }
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        String tableName = update.getTable().getName();
        if (!this.checkTableCreator(tableName)) {
            return;
        }
        Expression where = update.getWhere();
        Expression sqlSegment = this.dataScope(where, null);
        if (null != sqlSegment) {
            update.setWhere(sqlSegment);
        }
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        String tableName = delete.getTable().getName();
        if (!this.checkTableCreator(tableName)) {
            return;
        }
        Expression sqlSegment = this.dataScope(delete.getWhere(), null);
        if (null != sqlSegment) {
            delete.setWhere(sqlSegment);
        }
    }

    protected void setWhere(PlainSelect plainSelect) {
        Expression sqlSegment;
        String tableName = plainSelect.getFromItem().toString();
        if (!this.checkTableCreator(tableName)) {
            return;
        }
        if (CollUtil.isEmpty((Collection)plainSelect.getJoins())) {
            tableName = null;
        }
        if (null != (sqlSegment = this.dataScope(plainSelect.getWhere(), tableName))) {
            plainSelect.setWhere(sqlSegment);
        }
    }

    protected Expression dataScope(Expression where, String mainTableName) {
        Expression queryExpression;
        DataPermScope dataPermScope = this.dataPermScopeHandler.getDataPermScope();
        DataScopeEnum scopeType = dataPermScope.getScopeType();
        switch (scopeType) {
            case SELF: {
                queryExpression = this.selfScope(mainTableName);
                break;
            }
            case DEPT_SCOPE: {
                Expression deptScopeExpression = this.deptScope(dataPermScope.getDeptScopeIds(), mainTableName);
                queryExpression = new OrExpression(deptScopeExpression, this.selfScope(mainTableName));
                break;
            }
            case USER_SCOPE: {
                queryExpression = this.userScope(dataPermScope.getUserScopeIds(), mainTableName);
                break;
            }
            case DEPT_AND_USER_SCOPE: {
                queryExpression = this.deptAndUserScope(dataPermScope.getDeptScopeIds(), dataPermScope.getUserScopeIds(), mainTableName);
                break;
            }
            case BELONG_DEPT: 
            case BELONG_DEPT_AND_SUB: {
                queryExpression = this.deptScope(dataPermScope.getDeptScopeIds(), mainTableName);
                break;
            }
            case ALL_SCOPE: {
                return where;
            }
            default: {
                throw new BizException("\u4ee3\u7801\u6709\u95ee\u9898");
            }
        }
        if (Objects.nonNull(where)) {
            return new AndExpression((Expression)new Parenthesis(queryExpression), where);
        }
        return new Parenthesis(queryExpression);
    }

    protected Expression selfScope(String mainTableName) {
        Long userId = DataPermContextHolder.getUserDetail().map(UserDetail::getId).orElseThrow(NotLoginPermException::new);
        return new EqualsTo((Expression)new Column(this.getPermColumn(mainTableName)), (Expression)new LongValue(userId.longValue()));
    }

    protected Expression userScope(Set<Long> userScopeIds, String mainTableName) {
        Long userId = DataPermContextHolder.getUserDetail().map(UserDetail::getId).orElseThrow(NotLoginPermException::new);
        List userExpressions = ((Set)Optional.ofNullable(userScopeIds).orElse(new HashSet())).stream().map(LongValue::new).collect(Collectors.toList());
        userExpressions.add(new LongValue(userId.longValue()));
        return new InExpression((Expression)new Column(this.getPermColumn(mainTableName)), (ItemsList)new ExpressionList(userExpressions));
    }

    protected Expression deptScope(Set<Long> deptIds, String mainTableName) {
        DataPermProperties.DataPerm dataPerm = this.dataPermProperties.getDataPerm();
        PlainSelect plainSelect = new PlainSelect();
        SelectExpressionItem selectItem = new SelectExpressionItem();
        selectItem.setExpression((Expression)new Column(dataPerm.getQueryField()));
        plainSelect.addSelectItems(new SelectItem[]{selectItem});
        plainSelect.setDistinct(new Distinct());
        plainSelect.setFromItem((FromItem)new Table(dataPerm.getTable()));
        List deptExpressions = ((Set)Optional.ofNullable(deptIds).orElse(new HashSet())).stream().map(LongValue::new).collect(Collectors.toList());
        if (deptExpressions.size() == 0) {
            deptExpressions.add(null);
        }
        plainSelect.setWhere((Expression)new InExpression((Expression)new Column(dataPerm.getWhereField()), (ItemsList)new ExpressionList(deptExpressions)));
        SubSelect subSelect = new SubSelect();
        subSelect.setSelectBody((SelectBody)plainSelect);
        return new InExpression((Expression)new Column(this.getPermColumn(mainTableName)), (ItemsList)subSelect);
    }

    protected Expression deptAndUserScope(Set<Long> deptScopeIds, Set<Long> userScopeIds, String mainTableName) {
        Expression deptScopeExpression = this.deptScope(deptScopeIds, mainTableName);
        Expression userScopeExpression = this.userScope(userScopeIds, mainTableName);
        return new OrExpression(deptScopeExpression, userScopeExpression);
    }

    protected boolean checkPermission() {
        if (!this.dataPermProperties.isEnableDataPerm()) {
            return false;
        }
        NestedPermission nestedPermission = DataPermContextHolder.getNestedPermission();
        if (Objects.nonNull(nestedPermission) && !nestedPermission.dataScope()) {
            return false;
        }
        Permission permission = DataPermContextHolder.getPermission();
        if (Objects.isNull(permission) || !permission.dataScope()) {
            return false;
        }
        return DataPermContextHolder.getUserDetail().map(UserDetail::isAdmin).orElseThrow(NotLoginPermException::new) == false;
    }

    protected boolean checkTableCreator(String tableName) {
        TableInfo tableInfo = MpUtil.getTableInfo((String)tableName);
        if (tableInfo == null) {
            log.warn("'{}' \u6570\u636e\u8868\u672a\u627e\u5230\u5bf9\u5e94\u7684MybatisPlus\u5b9e\u4f53\u7c7b\uff0c\u5c06\u4e0d\u4f1a\u542f\u7528\u6570\u636e\u6743\u9650\u63a7\u5236\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (Object)tableName);
            return false;
        }
        Permission permission = tableInfo.getEntityType().getAnnotation(Permission.class);
        if (Objects.nonNull(permission) && permission.dataScope()) {
            return false;
        }
        boolean b = tableInfo.getFieldList().stream().map(TableFieldInfo::getColumn).anyMatch("creator"::equalsIgnoreCase);
        if (!b) {
            log.warn("'{}' \u6570\u636e\u8868\u672a\u627e\u5230\u6743\u9650\u63a7\u5236\u5b57\u6bb5 'creator' \uff0c\u5c06\u4e0d\u4f1a\u542f\u7528\u6570\u636e\u6743\u9650\u63a7\u5236\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (Object)tableName);
        }
        return b;
    }

    protected String getPermColumn(String mainTableName) {
        String column = StrUtil.isNotBlank((CharSequence)mainTableName) ? mainTableName + "." + "creator" : "creator";
        return column;
    }

    public DataScopeInterceptor(DataPermProperties dataPermProperties, DataPermScopeHandler dataPermScopeHandler) {
        this.dataPermProperties = dataPermProperties;
        this.dataPermScopeHandler = dataPermScopeHandler;
    }
}

