/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.starter.data.perm.local;

import cn.bootx.platform.common.core.annotation.NestedPermission;
import cn.bootx.platform.common.core.annotation.Permission;
import cn.bootx.platform.common.core.entity.UserDetail;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Optional;

public class DataPermContextHolder {
    private static final ThreadLocal<Permission> PERMISSION_LOCAL = new TransmittableThreadLocal();
    private static final ThreadLocal<NestedPermission> NESTED_PERMISSION_LOCAL = new TransmittableThreadLocal();
    private static final ThreadLocal<UserDetail> USER_DETAIL_LOCAL = new TransmittableThreadLocal();

    public static void putPermission(Permission permission) {
        PERMISSION_LOCAL.set(permission);
    }

    public static Permission getPermission() {
        return PERMISSION_LOCAL.get();
    }

    public static void putNestedPermission(NestedPermission nestedPermission) {
        NESTED_PERMISSION_LOCAL.set(nestedPermission);
    }

    public static NestedPermission getNestedPermission() {
        return NESTED_PERMISSION_LOCAL.get();
    }

    public static void putUserDetail(UserDetail dataPerm) {
        USER_DETAIL_LOCAL.set(dataPerm);
    }

    public static Optional<UserDetail> getUserDetail() {
        return Optional.ofNullable(USER_DETAIL_LOCAL.get());
    }

    public static void clearUserAndPermission() {
        USER_DETAIL_LOCAL.remove();
        PERMISSION_LOCAL.remove();
    }

    public static void clearNestedPermission() {
        NESTED_PERMISSION_LOCAL.remove();
    }
}

