/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.starter.data.perm.handler;

import cn.bootx.platform.common.core.annotation.NestedPermission;
import cn.bootx.platform.common.core.annotation.Permission;
import cn.bootx.platform.common.spring.util.AopUtil;
import cn.bootx.platform.starter.auth.util.SecurityUtil;
import cn.bootx.platform.starter.data.perm.local.DataPermContextHolder;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataPermAspectHandler {
    private static final Logger log = LoggerFactory.getLogger(DataPermAspectHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(permission)||@within(permission)")
    public Object doAround(ProceedingJoinPoint pjp, Permission permission) throws Throwable {
        Object obj;
        Permission methodAnnotation = (Permission)AopUtil.getMethodAnnotation((JoinPoint)pjp, Permission.class);
        if (Objects.nonNull(methodAnnotation)) {
            DataPermContextHolder.putPermission(methodAnnotation);
        } else {
            DataPermContextHolder.putPermission(permission);
        }
        DataPermContextHolder.putUserDetail(SecurityUtil.getCurrentUser().orElse(null));
        try {
            obj = pjp.proceed();
        }
        finally {
            DataPermContextHolder.clearUserAndPermission();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(nestedPermission)||@within(nestedPermission)")
    public Object doAround(ProceedingJoinPoint pjp, NestedPermission nestedPermission) throws Throwable {
        Object obj;
        NestedPermission methodAnnotation = (NestedPermission)AopUtil.getMethodAnnotation((JoinPoint)pjp, NestedPermission.class);
        if (Objects.nonNull(methodAnnotation)) {
            DataPermContextHolder.putNestedPermission(methodAnnotation);
        } else {
            DataPermContextHolder.putNestedPermission(nestedPermission);
        }
        DataPermContextHolder.putUserDetail(SecurityUtil.getCurrentUser().orElse(null));
        try {
            obj = pjp.proceed();
        }
        finally {
            DataPermContextHolder.clearNestedPermission();
        }
        return obj;
    }
}

