/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.starter.data.perm.dbencrypt;

import cn.bootx.platform.common.core.annotation.EncryptionField;
import cn.bootx.platform.starter.data.perm.configuration.DataPermProperties;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
@Component
public class EncryptInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptInterceptor.class);
    private final DataPermProperties dataPermProperties;

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (this.dataPermProperties.isEnableFieldDecrypt() && args.length < 2) {
            return invocation.proceed();
        }
        Object arg = args[1];
        if (arg instanceof Map) {
            Map map = (Map)arg;
            if (map.containsKey("et")) {
                Object object = map.get("et");
                this.encrypt(object);
            }
        } else {
            this.encrypt(arg);
        }
        return invocation.proceed();
    }

    public void encrypt(Object object) {
        Field[] fields;
        if (Objects.isNull(object)) {
            return;
        }
        for (Field field2 : fields = ReflectUtil.getFields(object.getClass(), field -> Objects.nonNull(field.getAnnotation(EncryptionField.class)))) {
            Object fieldValue = this.encryptValue(ReflectUtil.getFieldValue((Object)object, (Field)field2));
            ReflectUtil.setFieldValue((Object)object, (Field)field2, (Object)fieldValue);
        }
    }

    public Object encryptValue(Object fieldValue) {
        if (fieldValue instanceof String) {
            AES aes = SecureUtil.aes((byte[])this.dataPermProperties.getFieldDecryptKey().getBytes(StandardCharsets.UTF_8));
            return aes.encryptBase64((String)fieldValue);
        }
        return fieldValue;
    }

    public EncryptInterceptor(DataPermProperties dataPermProperties) {
        this.dataPermProperties = dataPermProperties;
    }
}

