/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.starter.data.perm.dbencrypt;

import cn.bootx.platform.common.core.annotation.EncryptionField;
import cn.bootx.platform.starter.data.perm.configuration.DataPermProperties;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
@Component
public class DecryptInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DecryptInterceptor.class);
    private final DataPermProperties dataPermProperties;

    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (!this.dataPermProperties.isEnableFieldDecrypt()) {
            return result;
        }
        return this.decrypt(result);
    }

    private Object decrypt(Object result) {
        if (result instanceof List) {
            ArrayList list = (ArrayList)result;
            for (Object o : list) {
                Field[] fields;
                if (Objects.isNull(o)) continue;
                for (Field field2 : fields = ReflectUtil.getFields(o.getClass(), field -> Objects.nonNull(field.getAnnotation(EncryptionField.class)))) {
                    Object fieldValue = this.decryptValue(ReflectUtil.getFieldValue(o, (Field)field2));
                    ReflectUtil.setFieldValue(o, (Field)field2, (Object)fieldValue);
                }
            }
            return list;
        }
        return result;
    }

    public Object decryptValue(Object fieldValue) {
        if (fieldValue instanceof String) {
            AES aes = SecureUtil.aes((byte[])this.dataPermProperties.getFieldDecryptKey().getBytes(StandardCharsets.UTF_8));
            return new String(aes.decrypt(Base64.decode((CharSequence)((String)fieldValue))), StandardCharsets.UTF_8);
        }
        return fieldValue;
    }

    public DecryptInterceptor(DataPermProperties dataPermProperties) {
        this.dataPermProperties = dataPermProperties;
    }
}

