/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.common.sequence.range;

import java.util.concurrent.atomic.AtomicLong;

public class SeqRange {
    private final long min;
    private final long max;
    private final AtomicLong value;
    private final int step;
    private volatile boolean over = false;

    public SeqRange(long min, long max, int step) {
        this.min = min;
        this.max = max;
        this.step = step;
        this.value = new AtomicLong(min);
    }

    public long getAndIncrement() {
        long currentValue = this.value.getAndAdd(this.step);
        if (currentValue > this.max) {
            this.over = true;
            return -1L;
        }
        return currentValue;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public AtomicLong getValue() {
        return this.value;
    }

    public int getStep() {
        return this.step;
    }

    public boolean isOver() {
        return this.over;
    }

    public SeqRange setOver(boolean over) {
        this.over = over;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeqRange)) {
            return false;
        }
        SeqRange other = (SeqRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMin() != other.getMin()) {
            return false;
        }
        if (this.getMax() != other.getMax()) {
            return false;
        }
        if (this.getStep() != other.getStep()) {
            return false;
        }
        if (this.isOver() != other.isOver()) {
            return false;
        }
        AtomicLong this$value = this.getValue();
        AtomicLong other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeqRange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = this.getMin();
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = this.getMax();
        result = result * 59 + (int)($max >>> 32 ^ $max);
        result = result * 59 + this.getStep();
        result = result * 59 + (this.isOver() ? 79 : 97);
        AtomicLong $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "SeqRange(min=" + this.getMin() + ", max=" + this.getMax() + ", value=" + this.getValue() + ", step=" + this.getStep() + ", over=" + this.isOver() + ")";
    }
}

