/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.common.sequence.range.jdbc;

import cn.bootx.platform.common.sequence.exception.SeqException;
import cn.bootx.platform.common.sequence.range.SeqRange;
import cn.bootx.platform.common.sequence.range.SeqRangeConfig;
import cn.bootx.platform.common.sequence.range.SeqRangeManager;
import cn.bootx.platform.common.sequence.range.jdbc.JdbcRangeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="bootx.common.sequence", value={"type"}, havingValue="jdbc", matchIfMissing=true)
public class JdbcSeqRangeManager
implements SeqRangeManager {
    private static final Logger log = LoggerFactory.getLogger(JdbcSeqRangeManager.class);
    private final JdbcRangeHandler jdbcRangeHandler;

    @Override
    public SeqRange nextRange(String name, SeqRangeConfig seqRangeConfig) throws SeqException {
        this.jdbcRangeHandler.setIfAbsentRange(name, seqRangeConfig.getRangeStart());
        int rangeStep = seqRangeConfig.getRangeStep();
        Long max = this.jdbcRangeHandler.incrementRange(name, rangeStep);
        long min = max - (long)rangeStep;
        return new SeqRange(min, max, seqRangeConfig.getStep());
    }

    public JdbcSeqRangeManager(JdbcRangeHandler jdbcRangeHandler) {
        this.jdbcRangeHandler = jdbcRangeHandler;
    }
}

