/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.common.sequence.range.jdbc;

import cn.bootx.platform.common.sequence.exception.SeqException;
import cn.bootx.platform.common.sequence.range.jdbc.SequenceRange;
import cn.bootx.platform.common.sequence.range.jdbc.SequenceRangeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JdbcRangeHandler {
    private static final Logger log = LoggerFactory.getLogger(JdbcRangeHandler.class);
    private final SequenceRangeManager manager;

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.DEFAULT)
    public void setIfAbsentRange(String key, long rangeStart) {
        if (!this.manager.existedByField(SequenceRange::getRangeKey, key)) {
            this.manager.save((Object)new SequenceRange().setRangeKey(key).setRangeValue(rangeStart));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long incrementRange(String key, int rangeStep) {
        SequenceRange range = (SequenceRange)((Object)this.manager.findByField(SequenceRange::getRangeKey, key).orElseThrow(() -> new SeqException("\u533a\u95f4\u4e0d\u5b58\u5728")));
        long stepValue = range.getRangeValue() + (long)rangeStep;
        range.setRangeValue(stepValue);
        this.manager.updateById((Object)range);
        return stepValue;
    }

    public JdbcRangeHandler(SequenceRangeManager manager) {
        this.manager = manager;
    }
}

