/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.common.sequence.range.mongo;

import cn.bootx.platform.common.sequence.exception.SeqException;
import cn.bootx.platform.common.sequence.range.mongo.SequenceRange;
import cn.hutool.core.util.IdUtil;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@ConditionalOnClass(name={"org.springframework.data.mongodb.core.MongoTemplate"})
@Repository
public class MongoRangeHandler {
    private final MongoTemplate mongoTemplate;

    public void setIfAbsentRange(String key, long rangeStart) {
        Criteria criteria = Criteria.where((String)"rangeKey").is((Object)key);
        Query query = new Query((CriteriaDefinition)criteria);
        if (!this.mongoTemplate.exists(query, SequenceRange.class)) {
            this.mongoTemplate.save((Object)new SequenceRange().setRangeKey(key).setRangeValue(rangeStart).setId(IdUtil.getSnowflakeNextId()));
        }
    }

    public Long incrementRange(String key, int rangeStep) {
        Criteria criteria = Criteria.where((String)"rangeKey").is((Object)key);
        Query query = new Query((CriteriaDefinition)criteria);
        SequenceRange range = (SequenceRange)Optional.ofNullable(this.mongoTemplate.findOne(query, SequenceRange.class)).orElseThrow(() -> new SeqException("\u533a\u95f4\u4e0d\u5b58\u5728"));
        long stepValue = range.getRangeValue() + (long)rangeStep;
        range.setRangeValue(stepValue);
        this.mongoTemplate.save((Object)range);
        return stepValue;
    }

    public MongoRangeHandler(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

