/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.common.sequence.configuration;

import cn.bootx.platform.common.sequence.configuration.SequenceProperties;
import cn.bootx.platform.common.sequence.func.Sequence;
import cn.bootx.platform.common.sequence.impl.DefaultRangeSequence;
import cn.bootx.platform.common.sequence.range.SeqRangeConfig;
import cn.bootx.platform.common.sequence.range.SeqRangeManager;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={SequenceProperties.class})
public class SequenceConfiguration {
    private final SequenceProperties sequenceProperties;

    @Bean
    @Primary
    public Sequence sequence(SeqRangeManager seqRangeManager) {
        SeqRangeConfig seqRangeConfig = new SeqRangeConfig().setStep(this.sequenceProperties.getStep()).setRangeStart(this.sequenceProperties.getRangeStart()).setRangeStep(this.sequenceProperties.getRangeStep());
        return new DefaultRangeSequence(seqRangeManager, seqRangeConfig);
    }

    public SequenceConfiguration(SequenceProperties sequenceProperties) {
        this.sequenceProperties = sequenceProperties;
    }
}

