/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.common.sequence.range.redis;

import cn.bootx.platform.common.redis.RedisClient;
import cn.bootx.platform.common.sequence.configuration.SequenceProperties;
import cn.bootx.platform.common.sequence.exception.SeqException;
import cn.bootx.platform.common.sequence.range.SeqRange;
import cn.bootx.platform.common.sequence.range.SeqRangeConfig;
import cn.bootx.platform.common.sequence.range.SeqRangeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="bootx.common.sequence", value={"type"}, havingValue="redis")
public class RedisSeqRangeManager
implements SeqRangeManager {
    private static final Logger log = LoggerFactory.getLogger(RedisSeqRangeManager.class);
    private final RedisClient redisClient;
    private final SequenceProperties sequenceProperties;

    @Override
    public SeqRange nextRange(String name, SeqRangeConfig seqRangeConfig) throws SeqException {
        this.redisClient.setIfAbsent(this.getRealKey(name), String.valueOf(seqRangeConfig.getRangeStart()));
        int rangeStep = seqRangeConfig.getRangeStep();
        Long max = this.redisClient.increment(this.getRealKey(name), (long)rangeStep);
        long min = max - (long)rangeStep;
        return new SeqRange(min, max, seqRangeConfig.getStep());
    }

    private String getRealKey(String name) {
        return this.sequenceProperties.getKeyPrefix() + name;
    }

    public RedisSeqRangeManager(RedisClient redisClient, SequenceProperties sequenceProperties) {
        this.redisClient = redisClient;
        this.sequenceProperties = sequenceProperties;
    }
}

