/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.common.sequence.range.mongo;

import cn.bootx.platform.common.sequence.exception.SeqException;
import cn.bootx.platform.common.sequence.range.SeqRange;
import cn.bootx.platform.common.sequence.range.SeqRangeConfig;
import cn.bootx.platform.common.sequence.range.SeqRangeManager;
import cn.bootx.platform.common.sequence.range.mongo.MongoRangeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="bootx.common.sequence", value={"type"}, havingValue="mongo")
public class MongoSeqRangeManager
implements SeqRangeManager {
    private static final Logger log = LoggerFactory.getLogger(MongoSeqRangeManager.class);
    private final MongoRangeHandler mongoRangeHandler;

    @Override
    public SeqRange nextRange(String name, SeqRangeConfig seqRangeConfig) throws SeqException {
        this.mongoRangeHandler.setIfAbsentRange(name, seqRangeConfig.getRangeStart());
        int rangeStep = seqRangeConfig.getRangeStep();
        Long max = this.mongoRangeHandler.incrementRange(name, rangeStep);
        long min = max - (long)rangeStep;
        return new SeqRange(min, max, seqRangeConfig.getStep());
    }

    public MongoSeqRangeManager(MongoRangeHandler mongoRangeHandler) {
        this.mongoRangeHandler = mongoRangeHandler;
    }
}

