/*
 * Decompiled with CFR 0.152.
 */
package cn.bootx.platform.common.sequence.impl;

import cn.bootx.platform.common.sequence.exception.SeqException;
import cn.bootx.platform.common.sequence.func.Sequence;
import cn.bootx.platform.common.sequence.range.SeqRange;
import cn.bootx.platform.common.sequence.range.SeqRangeConfig;
import cn.bootx.platform.common.sequence.range.SeqRangeManager;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultRangeSequence
implements Sequence {
    private final Lock lock = new ReentrantLock();
    private final SeqRangeManager seqRangeManager;
    private volatile SeqRange currentRange;
    private final SeqRangeConfig seqRangeConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long next(String name) throws SeqException {
        long value;
        if (null == this.currentRange) {
            this.lock.lock();
            try {
                if (null == this.currentRange) {
                    this.currentRange = this.seqRangeManager.nextRange(name, this.seqRangeConfig);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((value = this.currentRange.getAndIncrement()) == -1L) {
            this.lock.lock();
            try {
                while (true) {
                    if (this.currentRange.isOver()) {
                        this.currentRange = this.seqRangeManager.nextRange(name, this.seqRangeConfig);
                    }
                    if ((value = this.currentRange.getAndIncrement()) == -1L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (value < 0L) {
            throw new SeqException("\u5e8f\u5217\u503c\u6ea2\u51fa, value = " + value);
        }
        return value;
    }

    public void setCurrentRange(SeqRange currentRange) {
        this.currentRange = currentRange;
    }

    public Lock getLock() {
        return this.lock;
    }

    public SeqRangeManager getSeqRangeManager() {
        return this.seqRangeManager;
    }

    public SeqRange getCurrentRange() {
        return this.currentRange;
    }

    public SeqRangeConfig getSeqRangeConfig() {
        return this.seqRangeConfig;
    }

    public DefaultRangeSequence(SeqRangeManager seqRangeManager, SeqRangeConfig seqRangeConfig) {
        this.seqRangeManager = seqRangeManager;
        this.seqRangeConfig = seqRangeConfig;
    }
}

