/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.v1;

import cn.blankcat.dto.websocket.Intent;
import cn.blankcat.dto.websocket.Session;
import cn.blankcat.dto.websocket.WSIdentityData;
import cn.blankcat.dto.websocket.WSOPCode;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.dto.websocket.WSResumeData;
import cn.blankcat.websocket.v1.MyListener;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsRetrofit {
    private static final Logger logger = LoggerFactory.getLogger((String)"WsRetrofit");
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void startWs(Session session) {
        OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(session.token().timeout(), TimeUnit.SECONDS).writeTimeout(session.token().timeout(), TimeUnit.SECONDS).connectTimeout(session.token().timeout(), TimeUnit.SECONDS).build();
        WebSocket webSocket = httpClient.newWebSocket(new Request.Builder().get().url(session.url()).build(), (WebSocketListener)new MyListener(session));
        WsRetrofit.identify(webSocket, session);
    }

    private static void write(WebSocket webSocket, WSPayload payload, Session session) {
        try {
            String json = objectMapper.writeValueAsString((Object)payload);
            webSocket.send(json);
            logger.info("{}(session)\u5199\u5165[{}]\u4fe1\u606f:{}", new Object[]{session.id(), WSOPCode.ofValue(payload.opCode()), json});
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage());
        }
    }

    public static void hello(WebSocket webSocket, Session session) {
        try {
            WSPayload wsPayloadSend = new WSPayload(WSOPCode.WSHeartbeat.getValue(), session.lastSeq(), "", null, null);
            Thread.startVirtualThread(() -> {
                while (true) {
                    try {
                        while (true) {
                            WsRetrofit.write(webSocket, wsPayloadSend, session);
                            Thread.sleep(33000L);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage());
                        continue;
                    }
                    break;
                }
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void resume(WebSocket webSocket, Session session) {
        WSResumeData data = new WSResumeData(session.token().getRealString(), session.id(), session.lastSeq());
        WSPayload resumePayload = new WSPayload(WSOPCode.WSResume.getValue(), 0L, "", data, null);
        logger.info("\u6b63\u5728\u6062\u590d\u8fde\u63a5...");
        WsRetrofit.write(webSocket, resumePayload, session);
    }

    public static void identify(WebSocket webSocket, Session session) {
        if (session.intent() == Intent.IntentNone.getValue()) {
            session = new Session(session.id(), session.url(), session.token(), Intent.IntentGuilds.getValue(), session.lastSeq(), session.shards());
        }
        Long[] shard = new Long[]{session.shards().shardID(), session.shards().shardCount()};
        WSIdentityData data = new WSIdentityData(session.token().getRealString(), session.intent(), shard, null);
        WSPayload identityPayload = new WSPayload(WSOPCode.WSIdentity.getValue(), 0L, "", data, null);
        logger.info("\u6b63\u5728\u8fdb\u884c\u9274\u6743...");
        WsRetrofit.write(webSocket, identityPayload, session);
    }
}

