/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.v1;

import cn.blankcat.dto.audio.AudioAction;
import cn.blankcat.dto.channel.Channel;
import cn.blankcat.dto.forum.ForumAuditResult;
import cn.blankcat.dto.forum.Post;
import cn.blankcat.dto.forum.Reply;
import cn.blankcat.dto.guild.Guild;
import cn.blankcat.dto.interaction.Interaction;
import cn.blankcat.dto.member.Member;
import cn.blankcat.dto.message.Message;
import cn.blankcat.dto.message.MessageAudit;
import cn.blankcat.dto.message.MessageDelete;
import cn.blankcat.dto.websocket.Session;
import cn.blankcat.dto.websocket.ShardConfig;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WSHelloData;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.dto.websocket.WebsocketAP;
import cn.blankcat.openapi.v1.OpenClient;
import cn.blankcat.openapi.v1.service.WsService;
import cn.blankcat.token.Token;
import cn.blankcat.websocket.handler.WsHandler;
import cn.blankcat.websocket.v1.WsRetrofit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsClient {
    public static final HashMap<Class<?>, ArrayList<WsHandler>> HANDLERS = new HashMap();
    private static final long concurrencyTimeWindowSec = 2L;
    private static final Logger logger = LoggerFactory.getLogger((String)"WsClient");

    public static void startClient() {
        WsService service = OpenClient.getService(WsService.class);
        Token token = Token.loadFromConfig(null, Token.Type.TYPE_BOT);
        try {
            WebsocketAP apiInfo = (WebsocketAP)service.ws().execute().body();
            logger.info("\u5373\u5c06\u542f\u52a8{}\u4e2asessions...", (Object)apiInfo.shards());
            int i = 0;
            while ((long)i < apiInfo.shards()) {
                ShardConfig shards = new ShardConfig(i, apiInfo.shards());
                Session session = new Session("", apiInfo.url(), token, WSEvent.allEventToIntent(), 1L, shards);
                WsRetrofit.startWs(session);
                ++i;
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    private long calcInterval(long maxConcurrency) {
        int i;
        if (maxConcurrency == 0L) {
            maxConcurrency = 1L;
        }
        return (i = Math.round(2.0f / (float)maxConcurrency)) <= 0 ? 1L : (long)i;
    }

    static {
        HANDLERS.put(Guild.class, new ArrayList());
        HANDLERS.put(Message.class, new ArrayList());
        HANDLERS.put(MessageDelete.class, new ArrayList());
        HANDLERS.put(MessageAudit.class, new ArrayList());
        HANDLERS.put(Channel.class, new ArrayList());
        HANDLERS.put(Member.class, new ArrayList());
        HANDLERS.put(AudioAction.class, new ArrayList());
        HANDLERS.put(Thread.class, new ArrayList());
        HANDLERS.put(Post.class, new ArrayList());
        HANDLERS.put(Reply.class, new ArrayList());
        HANDLERS.put(ForumAuditResult.class, new ArrayList());
        HANDLERS.put(Interaction.class, new ArrayList());
        HANDLERS.put(WSHelloData.class, new ArrayList());
        HANDLERS.put(WSPayload.class, new ArrayList());
    }
}

