/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.v1;

import cn.blankcat.dto.websocket.Session;
import cn.blankcat.dto.websocket.ShardConfig;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WSEventType;
import cn.blankcat.dto.websocket.WSOPCode;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.dto.websocket.WSReadyData;
import cn.blankcat.websocket.handler.WsHandler;
import cn.blankcat.websocket.v1.WsClient;
import cn.blankcat.websocket.v1.WsRetrofit;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyListener
extends WebSocketListener {
    private final Logger logger = LoggerFactory.getLogger((String)"MyListener");
    private Session session;

    public MyListener(Session session) {
        this.session = session;
    }

    private void buildInHandler(WebSocket webSocket, WSPayload<?> wsPayload) throws JsonProcessingException {
        WSOPCode wsOPCode = WSOPCode.ofValue(wsPayload.opCode());
        switch (wsOPCode) {
            case WSDispatchEvent: {
                if ("READY".equals(wsPayload.type())) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    WSReadyData readyData = (WSReadyData)objectMapper.convertValue(wsPayload.data(), WSReadyData.class);
                    ShardConfig shardConfig = new ShardConfig(readyData.shard()[0], readyData.shard()[1]);
                    this.session = new Session(readyData.sessionID(), this.session.url(), this.session.token(), this.session.intent(), wsPayload.seq(), shardConfig);
                }
                if (!"RESUMED".equals(wsPayload.type())) break;
                break;
            }
            case WSHello: {
                WsRetrofit.hello(webSocket, this.session);
                break;
            }
            case WSHeartbeatAck: {
                break;
            }
            case WSReconnect: {
                WsRetrofit.resume(webSocket, this.session);
                break;
            }
            case WSInvalidSession: {
                WsRetrofit.identify(webSocket, this.session);
            }
        }
    }

    public void onMessage(WebSocket webSocket, String text) {
        this.logger.info("\u6536\u5230\u4fe1\u606f-->[{}]", (Object)text);
        ObjectMapper mapper = new ObjectMapper();
        try {
            WSEventType wsEventType;
            Class<?> clazz;
            WSPayload wsPayload = (WSPayload)mapper.readValue(text, WSPayload.class);
            if (wsPayload.seq() > 0L) {
                this.session = new Session(this.session.id(), this.session.url(), this.session.token(), this.session.intent(), wsPayload.seq(), this.session.shards());
            }
            if ((clazz = WSEvent.eventClassMap.get((Object)(wsEventType = WSEventType.ofValue(wsPayload.type())))) == null) {
                this.buildInHandler(webSocket, wsPayload);
            } else {
                for (WsHandler handler : WsClient.HANDLERS.get(clazz)) {
                    handler.handle(text, webSocket);
                }
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
        if (response != null && response.body() != null) {
            MediaType mediaType = response.body().contentType();
            try {
                String responseString = response.body().string();
                if (response.code() > 209) {
                    this.logger.warn("\u8bf7\u6c42\u9519\u8bef, \u9519\u8bef\u5185\u5bb9\u4e3a:{}", (Object)responseString);
                }
                super.onFailure(webSocket, t, response.newBuilder().body(ResponseBody.create((MediaType)mediaType, (String)responseString)).build());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
    }
}

