/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.openapi.v1;

import cn.blankcat.openapi.v1.Resource;
import cn.blankcat.token.Token;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public enum OpenRetrofit {
    SANDBOX(true),
    PRODUCT(false);

    private final Retrofit retrofit;
    private final Logger logger = LoggerFactory.getLogger((String)"OpenRetrofit");

    private OpenRetrofit(Boolean isSandbox) {
        Token token = Token.loadFromConfig(null, Token.Type.TYPE_BOT);
        this.retrofit = new Retrofit.Builder().baseUrl(Resource.getDomain(isSandbox)).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).client(new OkHttpClient().newBuilder().addInterceptor(chain -> {
            Request request = chain.request().newBuilder().addHeader("Authorization", token.getRealString()).build();
            return chain.proceed(request);
        }).addInterceptor(chain -> {
            Response response = chain.proceed(chain.request());
            MediaType mediaType = response.body().contentType();
            String responseString = response.body().string();
            if (response.code() > 209) {
                this.logger.warn("\u8bf7\u6c42\u9519\u8bef, \u9519\u8bef\u5185\u5bb9\u4e3a:{}", (Object)responseString);
            }
            return response.newBuilder().body(ResponseBody.create((MediaType)mediaType, (String)responseString)).build();
        }).readTimeout(token.timeout(), TimeUnit.SECONDS).writeTimeout(token.timeout(), TimeUnit.SECONDS).connectTimeout(token.timeout(), TimeUnit.SECONDS).build()).build();
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }
}

