package cn.blankcat.websocket.v1.dto;


import cn.blankcat.dto.websocket.Session;
import cn.blankcat.dto.websocket.WSUser;
import cn.blankcat.token.Token;
import cn.blankcat.websocket.WsApiVersion;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.Timer;

@JsonIgnoreProperties(ignoreUnknown = true)
public record WsData(
        long version,
        Session session,
        WSUser user,
        Timer heartBeatTicker
){
    public static WsData fromDefault(){
        return new WsData(WsApiVersion.APIv1, null, null, new Timer());
    }
    public static WsData fromToken(Token token){
        return new WsData(WsApiVersion.APIv1, null, null, new Timer());
    }
}
