package cn.blankcat.websocket.v1;

import cn.blankcat.dto.websocket.*;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

public class WsRetrofit {

    private static final Logger logger = LoggerFactory.getLogger("WsRetrofit");
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void startWs(Session session){
        OkHttpClient httpClient = new OkHttpClient.Builder()
                .readTimeout(session.token().timeout(), TimeUnit.SECONDS)
                .writeTimeout(session.token().timeout(), TimeUnit.SECONDS)
                .connectTimeout(session.token().timeout(), TimeUnit.SECONDS)
                .build();
        WebSocket webSocket = httpClient.newWebSocket(new Request.Builder().get().url(session.url()).build(), new MyListener(session));
        identify(webSocket, session);
    }

    private static void write(WebSocket webSocket, WSPayload payload, Session session){
        try {
            String json = objectMapper.writeValueAsString(payload);
            webSocket.send(json);
            logger.info("{}(session)写入[{}]信息:{}", session.id(), WSOPCode.ofValue(payload.opCode()), json);
        } catch (JsonProcessingException e) {
            logger.error(e.getMessage());
        }
    }

    public static void hello(WebSocket webSocket, Session session){
        try {
            WSPayload<Long> wsPayloadSend = new WSPayload<>(WSOPCode.WSHeartbeat.getValue(), session.lastSeq(), "", null, null);
            //write(webSocket, wsPayloadSend, session);
            // 接收到 hello 后需要开始发心跳
            Thread.startVirtualThread(() -> {
                while (true){
                    try {
                        write(webSocket, wsPayloadSend, session);
                        Thread.sleep(41250 * 4/ 5);
                    } catch (InterruptedException e) {
                        logger.error(e.getMessage());
                    }
                }
            });
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void resume(WebSocket webSocket, Session session){
        WSResumeData data = new WSResumeData(session.token().getRealString(),
                session.id(), session.lastSeq());
        WSPayload<WSResumeData> resumePayload = new WSPayload<>(WSOPCode.WSResume.getValue(), 0, "", data, null);
        logger.info("正在恢复连接...");
        write(webSocket, resumePayload, session);
    }

    public static void identify(WebSocket webSocket, Session session){
        if (session.intent() == Intent.IntentNone.getValue()){
            session = new Session(session.id(), session.url(), session.token(),
                    Intent.IntentGuilds.getValue(), session.lastSeq(), session.shards());
        }
        Long[] shard = {session.shards().shardID(), session.shards().shardCount()};
        WSIdentityData data = new WSIdentityData(session.token().getRealString(),
                session.intent(), shard, null);

        WSPayload<WSIdentityData> identityPayload = new WSPayload<>(WSOPCode.WSIdentity.getValue(), 0, "", data, null);
        logger.info("正在进行鉴权...");
        write(webSocket, identityPayload, session);
    }

}
