package cn.blankcat.websocket.handler;

import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.websocket.v1.WsClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractWebsocketHandler<T> implements WsHandler{

    protected final Logger logger = LoggerFactory.getLogger("websocketHandler");
    protected final ObjectMapper mapper = new ObjectMapper();
    protected Class<T> clazz;

    public void registry(){
        if (!WsClient.HANDLERS.get(getActualType()).contains(this)){
            WsClient.HANDLERS.get(getActualType()).add(this);
        }
        logger.info("已在{}服务中注册handler-------->{}", this.clazz.getSimpleName(), this.getClass().getSimpleName());
    }

    @SuppressWarnings("unchecked")
    private Class<T> getActualType(){
        if (clazz == null){
            Type superclass = this.getClass().getGenericSuperclass();
            if (superclass instanceof ParameterizedType
                    && ((ParameterizedType) superclass).getRawType().equals(AbstractWebsocketHandler.class)) {
                Type actualTypeArgument = ((ParameterizedType) superclass).getActualTypeArguments()[0];
                clazz = (Class<T>) actualTypeArgument;
            }
            if (clazz == null) {
                logger.error("{} 没有获取到泛型类型, 请为WebsocketHandler指定一个泛型用于消息Data的转换", this.getClass().getName());
            }
        }
        return clazz;
    }

    public T getPayloadData(String message) {
        getActualType();
        try {
            WSPayload<T> payload = mapper.readValue(message, mapper.getTypeFactory().constructParametricType(WSPayload.class, clazz));
            return mapper.convertValue(payload.data(), clazz);
        } catch (JsonProcessingException e) {
            logger.error(e.getMessage());
        }
        return null;
    }

}
