package cn.blankcat.token;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;

@JsonIgnoreProperties(ignoreUnknown = true)
public record Token (
        long appId,

        String accessToken,

        Type type,

        long timeout,

        Boolean inSandBox
){

    private static final Logger logger = LoggerFactory.getLogger("token");
    public static final Token EMPTY = new Token(0,"", Type.TYPE_NORMAL, 3, false);

    public enum Type{
        TYPE_BOT("Bot"),
        TYPE_NORMAL("Bearer");

        private final String value;

        Type(String value){
            this.value = value;
        }
        @JsonValue
        public String getValue(){
            return value;
        }
    }

    public String getRealString(){
        if (this.type == Type.TYPE_NORMAL){
            return this.type.value + " " + this.accessToken;
        }
        return this.type.value + " " + this.appId + "." + this.accessToken;
    }

    public static Token BotToken(long appId, String accessToken){
        return new Token(appId, accessToken, Type.TYPE_BOT, 3, false);
    }

    public static Token UserToken(long appId, String accessToken){
        return new Token(appId, accessToken, Type.TYPE_NORMAL, 3, false);
    }

    public static Token loadFromConfig(String filePath, Type tokenType){
        if (filePath == null || filePath.isEmpty()) {
            filePath = "bot.json";
        }
        ObjectMapper mapper = new ObjectMapper();
        InputStream inputStream = Token.class
                .getClassLoader()
                .getResourceAsStream(filePath);
        mapper.findAndRegisterModules();
        try {
            Token token = mapper.readValue(inputStream, Token.class);
            if (token.accessToken().isEmpty() || token.accessToken().isBlank()){
                logger.warn("error read token from file ");
            }
            if (token.appId() ==0 ){
                logger.warn("error read appid from file ");
            }
            token = new Token(token.appId(), token.accessToken(), tokenType, token.timeout(), token.inSandBox);
            return token;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EMPTY;
    }
}
