package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.gateway.HTTPIdentity;
import cn.blankcat.dto.gateway.HTTPReady;
import cn.blankcat.dto.gateway.HTTPSession;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.*;

public interface WebhookService{

    // CreateSession 创建一个新的 http 事件回调
    @POST(Resource.httpSessionsURI)
    Call<HTTPReady> createSession(@Body HTTPIdentity identity);

    // CheckSessions 定期检查 http 回调 session 的健康情况，服务端会自动 resume 非活跃状态的 session
    @PATCH(Resource.httpSessionsURICheck)
    Call<HTTPSession[]> CheckSessions();

    // GetActiveSessionList 拉取活跃的 http session 列表
    @GET(Resource.httpSessionsURI)
    Call<HTTPSession[]> sessionList();

    // RemoveSession 停止某个 session
    @DELETE(Resource.httpSessionURI)
    Call<String> removeSession(@Path("session_id") String sessionID);


}
