package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.schedule.Schedule;
import cn.blankcat.dto.schedule.ScheduleWrapper;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.*;

public interface ScheduleService{

    // ListSchedules 查询某个子频道下，since开始的当天的日程列表。若since为0，默认返回当天的日程列表
    @GET(Resource.schedulesURI)
    Call<String> listSchedules(@Path("channel_id") String channelId,
                               @Query("since") Long since);

    // GetSchedule 获取单个日程信息
    @GET(Resource.scheduleURI)
    Call<Schedule> getSchedule(@Path("channel_id") String channelId,
                               @Path("schedule_id") String scheduleId);

    // CreateSchedule 创建日程
    @POST(Resource.schedulesURI)
    Call<Schedule> createSchedule(@Path("channel_id") String channelId,
                                  @Body ScheduleWrapper schedule);

    // ModifySchedule 修改日程
    @PATCH(Resource.scheduleURI)
    Call<Schedule> modifySchedule(@Path("channel_id") String channelId,
                                  @Path("schedule_id") String scheduleId,
                                  @Body ScheduleWrapper schedule);

    // DeleteSchedule 删除日程
    @DELETE(Resource.scheduleURI)
    Call<String> deleteSchedule(@Path("channel_id") String channelId,
                                @Path("schedule_id") String scheduleId);


}
