package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.pin.PinsMessage;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface PinService{

    // AddPins 添加精华消息
    @PUT(Resource.pinURI)
    Call<PinsMessage> addPins(@Path("channel_id") String channelID,
                              @Path("message_id") String messageID);

    // DeletePins 删除精华消息
    @DELETE(Resource.pinURI)
    Call<String> PinsMessage(@Path("channel_id") String channelID,
                             @Path("message_id") String messageID);

    // GetPins 获取精华消息
    @GET(Resource.pinsURI)
    Call<PinsMessage> getPins(@Path("channel_id") String channelID);

    // CleanPins 清除全部精华消息
    @DELETE(Resource.pinURIAll)
    Call<PinsMessage> cleanPins(@Path("channel_id") String channelID);


}
