package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.mute.UpdateGuildMute;
import cn.blankcat.dto.mute.UpdateGuildMuteResponse;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.PATCH;
import retrofit2.http.Path;

public interface MuteService{

    // GuildMute 频道禁言
    @PATCH(Resource.guildMuteURI)
    Call<String> guildMute(@Path("guild_id") String guildID,
                           @Body UpdateGuildMute mute);

    // MemberMute 频道指定成员禁言
    @PATCH(Resource.guildMembersMuteURI)
    Call<String> memberMute(@Path("guild_id") String guildID,
                            @Path("user_id") String userID,
                            @Body UpdateGuildMute mute);

    // MultiMemberMute 频道批量成员禁言
    @PATCH(Resource.guildMuteURI)
    Call<UpdateGuildMuteResponse> multiMemberMute(@Path("guild_id") String guildID,
                                                  @Body UpdateGuildMute mute);


}
