package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.member.Member;
import cn.blankcat.dto.member.MemberDeleteOpts;
import cn.blankcat.dto.role.MemberAddRoleBody;
import cn.blankcat.openapi.v1.Resource;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import retrofit2.Call;
import retrofit2.http.*;

import java.util.Map;

public interface MemberService{

    // MemberAddRole 添加成员角色
    @PUT(Resource.memberRoleURI)
    Call<String> memberAddRole(@Path("guild_id") String guildId,
                               @Path("role_id") String roleID,
                               @Path("user_id") String userID,
                               @Body MemberAddRoleBody value);

    // MemberDeleteRole 删除成员角色
    @DELETE(Resource.memberRoleURI)
    Call<String> memberDeleteRole(@Path("guild_id") String guildId,
                                  @Path("role_id") String roleID,
                                  @Path("user_id") String userID,
                                  @Body MemberAddRoleBody value);

    // GuildMember 拉取频道指定成员
    @GET(Resource.guildMemberURI)
    Call<Member> guildMember(@Path("guild_id") String guildId,
                             @Path("user_id") String userID);

    // GuildMembers 分页拉取频道内成员列表
    @GET(Resource.guildMemberURI)
    Call<Member[]> guildMembers(@Path("guild_id") String guildId,
                              @QueryMap Map<String,String> pager);

    // GuildRoleMembers 分页拉取频道内身份组成员列表
    @GET(Resource.guildRoleMemberURI)
    Call<RoleMembersRsp> guildRoleMembers(@Path("guild_id") String guildId,
                                  @Path("role_id") String roleID,
                                  @QueryMap Map<String,String> pager);

    // DeleteGuildMember 将指定成员踢出频道
    @DELETE(Resource.guildMemberURI)
    Call<Member> deleteGuildMember(@Path("guild_id") String guildId,
                                   @Path("role_id") String roleID,
                                   @Body MemberDeleteOpts opts);


    @JsonIgnoreProperties(ignoreUnknown = true)
    class RoleMembersRsp{
        private Member[] data;
        private String next;
    }
}
