package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.dm.DirectMessage;
import cn.blankcat.dto.dm.DirectMessageToCreate;
import cn.blankcat.dto.message.Message;
import cn.blankcat.dto.message.MessageToCreate;
import cn.blankcat.dto.message.SettingGuideToCreate;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface DirectMessageService{

    // CreateDirectMessage 创建私信频道
    @POST(Resource.userMeDMURI)
    Call<DirectMessage> createDirectMessage(@Body DirectMessageToCreate dm);

    // PostDirectMessage 在私信频道内发消息
    @POST(Resource.dmsURI)
    Call<Message> postDirectMessage(@Path("guild_id") String guildId,
                                    @Body MessageToCreate msg);

    // RetractDMMessage 撤回私信消息
    @DELETE(Resource.dmsMessageURI)
    Call<String> retractDMMessage(@Path("guild_id") String guildID,
                                  @Path("message_id") String msgID);

    // PostDMSettingGuide 发送私信设置引导, jumpGuildID为设置引导要跳转的频道ID
    @POST(Resource.dmSettingGuideURI)
    Call<Message> putChannelRolesPermissions(@Path("guild_id") String guildId,
                                             @Body SettingGuideToCreate msg);

}
