package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.announce.Announces;
import cn.blankcat.dto.announce.ChannelAnnouncesToCreate;
import cn.blankcat.dto.announce.GuildAnnouncesToCreate;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface AnnounceService{

    // CreateChannelAnnounces 创建子频道公告
    @POST(Resource.channelAnnouncesURI)
    Call<Announces> createChannelAnnounces(@Path("channel_id") String channelId,
                                           @Body ChannelAnnouncesToCreate announce);

    // DeleteChannelAnnounces 删除子频道公告,会校验 messageID
    @DELETE(Resource.channelAnnounceURI)
    Call<Announces> deleteChannelAnnounces(@Path("channel_id") String channelId,
                                        @Path("message_id") String messageId);


    // CleanChannelAnnounces 删除子频道公告,不校验 messageID
    @DELETE(Resource.channelAnnounceURIAll)
    Call<Announces> cleanChannelAnnounces(@Path("channel_id") String channelId);

    // CreateGuildAnnounces 创建频道全局公告
    @POST(Resource.guildAnnouncesURI)
    Call<Announces> createGuildAnnounces(@Path("guild_id") String guildID,
                                      @Body GuildAnnouncesToCreate announce);

    // DeleteGuildAnnounces 删除频道全局公告,会校验 messageID
    @DELETE(Resource.guildAnnounceURI)
    Call<Announces> deleteGuildAnnounces(@Path("guild_id") String guildID,
                                      @Path("message_id") String messageId);

    // CleanGuildAnnounces 删除道全局公告,不校验 messageID
    @DELETE(Resource.guildAnnounceURI)
    Call<Announces> cleanGuildAnnounces(@Path("guild_id") String guildID);

}
