package cn.blankcat.openapi.v1.dto;

import cn.blankcat.openapi.OpenApiVersion;
import cn.blankcat.token.Token;

public record OpenData(
        Token token,
        // MaxIdleConns 默认指定空闲连接池大小
        Integer maxIdleConns,
        Long version,
        // debug 模式，调试sdk时候使用
        Boolean debug,
        // lastTraceID id
        String lastTraceID
) {
    public static OpenData fromDefault(){
        return new OpenData(null, 3000, OpenApiVersion.APIv1, false, "");
    }
    public static OpenData fromToken(Token token){
        return new OpenData(token, 3000, OpenApiVersion.APIv1, false, "");
    }
}
