package cn.blankcat.openapi.v1;

import cn.blankcat.token.Token;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

import java.util.concurrent.TimeUnit;

public enum OpenRetrofit {

    SANDBOX(true),
    PRODUCT(false);
    private final Retrofit retrofit ;
    private final Logger logger = LoggerFactory.getLogger("OpenRetrofit");
    OpenRetrofit(Boolean isSandbox){
        Token token = Token.loadFromConfig(null, Token.Type.TYPE_BOT);
        retrofit = new Retrofit.Builder()
                .baseUrl(Resource.getDomain(isSandbox))//设置网络请求时的Url地址
                .addConverterFactory(JacksonConverterFactory.create())//设置数据解析器
                .client(new OkHttpClient().newBuilder()
                        .addInterceptor(chain -> {
                            Request request = chain.request().newBuilder()
                                    .addHeader("Authorization", token.getRealString())
                                    .build();
                            return chain.proceed(request);
                        })
                        .addInterceptor(chain -> {
                            Response response = chain.proceed(chain.request());
                            MediaType mediaType = response.body().contentType();
                            String responseString = response.body().string();
                            if (response.code() > 209) {
                                logger.warn("请求错误, 错误内容为:{}", responseString);
                            }
                            return response.newBuilder().body(ResponseBody.create(mediaType, responseString)).build();
                        })
                        .readTimeout(token.timeout(), TimeUnit.SECONDS)
                        .writeTimeout(token.timeout(), TimeUnit.SECONDS)
                        .connectTimeout(token.timeout(), TimeUnit.SECONDS)
                        .build())
                .build();
    }

    public Retrofit getRetrofit(){
        return retrofit;
    }

}
