package cn.blankcat.err;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;

public enum ErrorCode {

    CodeNeedReConnect(9000),
    CodeNotFoundOpenAPI(9003),
    CodeConnCloseCantResume(9005),
    CodeConnCloseCantIdentify(9006),
    CodePagerIsNil(9007);


    private final int value;
    ErrorCode(int valueIn){
        this.value = valueIn;
    }
    @JsonValue
    public int getValue(){
        return value;
    }


    // 根据value获取WSEventType
    public static ErrorCode ofValue(int valueIn){
        return Arrays.stream(ErrorCode.values()).filter(ErrorCode -> ErrorCode.value == valueIn).findFirst().orElse(null);
    }
}
