package cn.blankcat.err;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
// Err sdk err
@JsonIgnoreProperties(ignoreUnknown = true)
public record Err (
        int code,
        String text,
        // 错误追踪ID，可用于向平台反馈问题
        String trace
){

    public String out(){
        return "code:" + this.code + ", text:" + this.text + ", traceID:" + this.trace;
    }

    // New 创建一个新错误
    public static Err newErr(int code, String text, String ...traces){
        return new Err(code, text, traces.length > 0 ? traces[0] : "");
    }

    public static Err exceptionToErr(Exception e){
        return new Err(9999, e.getMessage(), "");
    }

}
