package cn.blankcat.dto.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
// WSPayload websocket 消息结构
public record WSPayload<T> (
        @JsonProperty("op")
        int opCode,
        @JsonProperty("s")
        long seq,
        @JsonProperty("t")
        String type,
        @JsonProperty("d")
        Object data,
        @JsonProperty("-")
        // 原始的 message 数据
        byte[] rawMessage
){}
