package cn.blankcat.dto.websocket;

import java.util.HashMap;
import java.util.Map;

public class WSOPMeans {

    public static Map<Integer, String> opMeans = new HashMap<>();

    // opMeans op 对应的含义字符串标识
    static {
        opMeans.put(WSOPCode.WSDispatchEvent.getValue(), "Event");
        opMeans.put(WSOPCode.WSHeartbeat.getValue(), "Heartbeat");
        opMeans.put(WSOPCode.WSIdentity.getValue(), "Identity");
        opMeans.put(WSOPCode.WSResume.getValue(), "Resume");
        opMeans.put(WSOPCode.WSReconnect.getValue(), "Reconnect");
        opMeans.put(WSOPCode.WSInvalidSession.getValue(), "InvalidSession");
        opMeans.put(WSOPCode.WSHello.getValue(), "Hello");
        opMeans.put(WSOPCode.WSHeartbeatAck.getValue(), "HeartbeatAck");
    }

    // OPMeans 返回 op 含义
    public static String OPMeans(WSOPCode op){
        String means = opMeans.get(op.getValue());
        if (means.isEmpty() || means.isBlank()){
            means = "unknown";
        }
        return means;
    }
}
