package cn.blankcat.dto.websocket;

import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Arrays;

// OPCode websocket op 码
public enum WSOPCode {

    WSDispatchEvent(0),
    WSHeartbeat(1),
    WSIdentity(2),
    WSResume(6),
    WSReconnect(7),
    WSInvalidSession(9),
    WSHello(10),
    WSHeartbeatAck(11),
    HTTPCallbackAck(12);


    private final int value;
    WSOPCode(int value){
        this.value = value;
    }
    @JsonValue
    public int getValue(){
        return value;
    }

    // 根据value获取WSEventType
    public static WSOPCode ofValue(int value){
        return Arrays.stream(WSOPCode.values()).filter(WSOPCode -> WSOPCode.value == value).findFirst().orElse(null);
    }

}
