package cn.blankcat.dto.websocket;

import cn.blankcat.token.Token;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
// Session 连接的 session 结构，包括链接的所有必要字段
public record Session (
        // Intent 类型
        String id,
        String url,
        Token token,
        int intent,
        long lastSeq,
        ShardConfig shards
){
    public String getBetterSession(){
        return "[ws][ID:"+ id +"][Shard:("+ shards.shardID() + "/" + shards.shardCount() +")][Intent:"+ intent +"]";
    }
}
