package cn.blankcat.dto.websocket;

import com.fasterxml.jackson.annotation.JsonValue;

public enum Intent{
    IntentGuilds(1),
    IntentGuildMembers(1 << 1),
    IntentGuildBans(1 << 2),
    IntentGuildEmojis(1 << 3),
    IntentGuildIntegrations(1 << 4),
    IntentGuildWebhooks(1 << 5),
    IntentGuildInvites(1 << 6),
    IntentGuildVoiceStates(1 << 7),
    IntentGuildPresences(1 << 8),
    IntentGuildMessages(1 << 9),
    IntentGuildMessageReactions(1 << 10),
    IntentGuildMessageTyping(1 << 11),
    IntentDirectMessages(1 << 12),
    IntentDirectMessageReactions(1 << 13),
    IntentDirectMessageTyping(1 << 14),
    // 互动事件
    IntentInteraction(1 << 26),
    // 审核事件
    IntentAudit(1 << 27),
    // 论坛事件
    IntentForum(1 << 28),
    // 音频机器人事件
    IntentAudio(1 << 29),
    // 只接收@消息事件
    IntentGuildAtMessage(1 << 30),
    IntentNone(0);
    private final int value;
    Intent(int value){
        this.value = value;
    }
    @JsonValue
    public int getValue(){
        return value;
    }
}
